/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Tag
implements Serializable {
    protected String name;
    protected String value;
    protected UnparsedTextList unparsedTexts = null;

    public Tag() {
    }

    public Tag(Tag tag) {
        this.name = tag.getName();
        this.value = tag.getValue();
        this.unparsedTexts = tag.unparsedTexts;
    }

    public Tag(String inner) {
        Objects.requireNonNull(inner, "parameter 'inner' cannot be null");
        int i = inner.indexOf(58);
        if (i >= 0) {
            if (i > 0) {
                this.name = inner.substring(0, i);
            }
            if (i + 1 < inner.length()) {
                this.value = inner.substring(i + 1);
            }
        } else if (inner.length() > 0) {
            this.value = inner;
        }
    }

    public Tag(String tagname, String value) {
        Objects.requireNonNull(tagname, "tag name cannot be null");
        this.name = tagname;
        this.value = value;
    }

    public Tag(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    public Tag(String inner, UnparsedTextList unparsedText) {
        this(inner);
        this.unparsedTexts = unparsedText;
    }

    public Tag(String tagname, String value, UnparsedTextList unparsedText) {
        this(tagname, value);
        this.unparsedTexts = unparsedText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "parameter 'name' cannot be null");
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Tag[" + this.name + ":" + this.value + "]";
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return 0;
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.name, tag.name) && Objects.equals(this.value, tag.value) && Objects.equals(this.unparsedTexts, tag.unparsedTexts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.unparsedTexts);
    }

    public boolean equalsIgnoreCR(Tag other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.unparsedTexts == null ? other.unparsedTexts != null : !this.unparsedTexts.equals(other.unparsedTexts)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return StringUtils.replace((String)this.value, (String)"\r", (String)"").equals(StringUtils.replace((String)other.value, (String)"\r", (String)""));
    }

    public int getNameAsInt() {
        try {
            return Integer.parseInt(this.name);
        }
        catch (Exception unused) {
            return -1;
        }
    }

    public boolean isNumber(int n) {
        return this.name != null && this.getNumber() != null && this.getNumber().equals(n);
    }

    public Integer getNumber() {
        if (this.name != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                try {
                    return Integer.parseInt(sb.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getLetterOption() {
        if (this.name != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isLetter(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    public boolean contains(String ... values) {
        if (values != null && values.length > 0) {
            String _v = this.getValue();
            for (String v : values) {
                if (!StringUtils.contains((CharSequence)_v, (CharSequence)v)) continue;
                return true;
            }
        }
        return false;
    }

    public void setNameValue(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public boolean startsWith(String prefix) {
        return StringUtils.startsWith((CharSequence)this.getValue(), (CharSequence)prefix);
    }

    public boolean contains(String searchStr) {
        return StringUtils.contains((CharSequence)this.getValue(), (CharSequence)searchStr);
    }

    public Field asField() {
        return Field.getField(this);
    }
}

