/*
* Copyright 2006-2024 Prowide
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.Generated;

/**
* Enumeration of fields for SRU 2024
*
* @since 9.5.2
*/
@Generated
public enum FieldEnum {

    F11A,
    F11R,
    F11S,
    F11T,
    F12A,
    F12B,
    F12C,
    F12D,
    F12E,
    F12F,
    F12G,
    F12H,
    F12K,
    F12L,
    F12R,
    F12S,
    F12,
    F13A,
    F13B,
    F13C,
    F13D,
    F13E,
    F13J,
    F13K,
    F14A,
    F14B,
    F14C,
    F14D,
    F14E,
    F14F,
    F14G,
    F14H,
    F14K,
    F14L,
    F14M,
    F14N,
    F14O,
    F14J,
    F14P,
    F14Q,
    F14R,
    F14S,
    F15A,
    F15B,
    F15C,
    F15D,
    F15E,
    F15F,
    F15G,
    F15H,
    F15I,
    F15J,
    F15K,
    F15L,
    F15M,
    F15N,
    F15O,
    F15P,
    F16A,
    F16C,
    F16D,
    F16R,
    F16S,
    F16W,
    F17A,
    F17B,
    F17C,
    F17E,
    F17F,
    F17G,
    F17H,
    F17I,
    F17L,
    F17M,
    F17N,
    F17O,
    F17P,
    F17Q,
    F17R,
    F17S,
    F17T,
    F17U,
    F17V,
    F17W,
    F17X,
    F17Y,
    F17Z,
    F18A,
    F18B,
    F18C,
    F18D,
    F19A,
    F19B,
    F19C,
    F19Y,
    F19Z,
    F19,
    F20C,
    F20D,
    F20E,
    F20U,
    F20,
    F21A,
    F21B,
    F21C,
    F21D,
    F21E,
    F21F,
    F21G,
    F21H,
    F21N,
    F21P,
    F21R,
    F21S,
    F21T,
    F21,
    F22A,
    F22B,
    F22C,
    F22D,
    F22E,
    F22F,
    F22G,
    F22H,
    F22K,
    F22L,
    F22M,
    F22N,
    F22P,
    F22Q,
    F22R,
    F22S,
    F22T,
    F22U,
    F22V,
    F22W,
    F22X,
    F22Y,
    F22Z,
    F22,
    F23A,
    F23B,
    F23C,
    F23D,
    F23E,
    F23F,
    F23G,
    F23H,
    F23R,
    F23S,
    F23X,
    F23,
    F24B,
    F24D,
    F24E,
    F24G,
    F25A,
    F25D,
    F25F,
    F25G,
    F25P,
    F25,
    F26A,
    F26B,
    F26C,
    F26D,
    F26E,
    F26F,
    F26H,
    F26K,
    F26T,
    F27,
    F27A,
    F28C,
    F28D,
    F28E,
    F28,
    F29A,
    F29B,
    F29D,
    F29E,
    F29F,
    F29H,
    F29I,
    F29J,
    F29L,
    F29M,
    F29N,
    F29O,
    F29P,
    F29S,
    F29T,
    F29U,
    F29Q,
    F29W,
    F30F,
    F30G,
    F30H,
    F30I,
    F30J,
    F30K,
    F30M,
    F30N,
    F30P,
    F30Q,
    F30S,
    F30T,
    F30U,
    F30V,
    F30X,
    F30Y,
    F30Z,
    F30,
    F31C,
    F31D,
    F31E,
    F31F,
    F31G,
    F31J,
    F31K,
    F31L,
    F31M,
    F31N,
    F31P,
    F31R,
    F31S,
    F31T,
    F31X,
    F32A,
    F32B,
    F32C,
    F32D,
    F32E,
    F32F,
    F32G,
    F32H,
    F32K,
    F32M,
    F32Q,
    F32R,
    F32U,
    F33A,
    F33B,
    F33C,
    F33D,
    F33E,
    F33F,
    F33G,
    F33H,
    F33J,
    F33K,
    F33S,
    F33T,
    F33Z,
    F34A,
    F34B,
    F34C,
    F34D,
    F34E,
    F34F,
    F34J,
    F34K,
    F34L,
    F34M,
    F34O,
    F34P,
    F34R,
    F34S,
    F34T,
    F34U,
    F34V,
    F34W,
    F34X,
    F34Y,
    F35A,
    F35B,
    F35C,
    F35D,
    F35E,
    F35G,
    F35H,
    F35L,
    F35N,
    F35S,
    F35U,
    F36B,
    F36C,
    F36D,
    F36E,
    F36,
    F37A,
    F37B,
    F37C,
    F37D,
    F37E,
    F37F,
    F37G,
    F37H,
    F37J,
    F37K,
    F37L,
    F37M,
    F37N,
    F37R,
    F37V,
    F38A,
    F38D,
    F38E,
    F38G,
    F38H,
    F38J,
    F39A,
    F39B,
    F39C,
    F39E,
    F39F,
    F39M,
    F40A,
    F40B,
    F40C,
    F40D,
    F40E,
    F40F,
    F41A,
    F41D,
    F41F,
    F41G,
    F42A,
    F42C,
    F42D,
    F42M,
    F42P,
    F43P,
    F43T,
    F44A,
    F44B,
    F44C,
    F44D,
    F44E,
    F44F,
    F44J,
    F45A,
    F45B,
    F45C,
    F45D,
    F45L,
    F46A,
    F46B,
    F47A,
    F47B,
    F47E,
    F48B,
    F48D,
    F48,
    F49A,
    F49D,
    F49F,
    F49G,
    F49H,
    F49J,
    F49K,
    F49L,
    F49M,
    F49N,
    F49Y,
    F49Z,
    F49,
    F50A,
    F50B,
    F50C,
    F50D,
    F50F,
    F50G,
    F50H,
    F50K,
    F50L,
    F50,
    F51A,
    F51C,
    F51D,
    F51,
    F52A,
    F52B,
    F52C,
    F52D,
    F53A,
    F53B,
    F53C,
    F53D,
    F53J,
    F54A,
    F54B,
    F54D,
    F55A,
    F55B,
    F55D,
    F56A,
    F56B,
    F56C,
    F56D,
    F56J,
    F57A,
    F57B,
    F57C,
    F57D,
    F57J,
    F58A,
    F58B,
    F58D,
    F58J,
    F59A,
    F59F,
    F59K,
    F59,
    F60F,
    F60M,
    F61,
    F62F,
    F62M,
    F64,
    F65,
    F68A,
    F69A,
    F69B,
    F69C,
    F69D,
    F69E,
    F69F,
    F69J,
    F70C,
    F70D,
    F70E,
    F70F,
    F70G,
    F70H,
    F70,
    F71A,
    F71B,
    F71C,
    F71D,
    F71E,
    F71F,
    F71G,
    F71M,
    F71N,
    F72Z,
    F72,
    F73A,
    F73R,
    F73S,
    F73,
    F74,
    F75,
    F76,
    F77A,
    F77B,
    F77C,
    F77D,
    F77E,
    F77F,
    F77H,
    F77J,
    F77L,
    F77T,
    F77U,
    F77,
    F78B,
    F78,
    F78D,
    F79Z,
    F79,
    F80C,
    F81A,
    F81D,
    F81J,
    F82A,
    F82B,
    F82D,
    F82J,
    F83A,
    F83C,
    F83D,
    F83J,
    F84A,
    F84B,
    F84D,
    F84J,
    F85A,
    F85B,
    F85D,
    F85J,
    F86A,
    F86B,
    F86D,
    F86J,
    F86,
    F87A,
    F87B,
    F87D,
    F87J,
    F88A,
    F88B,
    F88D,
    F88J,
    F89A,
    F89D,
    F89J,
    F90A,
    F90B,
    F90C,
    F90D,
    F90E,
    F90F,
    F90J,
    F90K,
    F90L,
    F91A,
    F91D,
    F91J,
    F92A,
    F92B,
    F92C,
    F92D,
    F92F,
    F92H,
    F92J,
    F92K,
    F92L,
    F92M,
    F92N,
    F92P,
    F92R,
    F93A,
    F93B,
    F93C,
    F93D,
    F93E,
    F93F,
    F94A,
    F94B,
    F94C,
    F94D,
    F94E,
    F94F,
    F94G,
    F94H,
    F94L,
    F95C,
    F95L,
    F95P,
    F95Q,
    F95R,
    F95S,
    F95U,
    F95V,
    F96A,
    F96D,
    F96J,
    F97A,
    F97B,
    F97C,
    F97D,
    F97E,
    F98A,
    F98B,
    F98C,
    F98D,
    F98E,
    F98F,
    F98G,
    F98H,
    F98J,
    F98K,
    F99A,
    F99B,
    F99C,
    F101,
    F102,
    F103,
    F104,
    F105,
    F106,
    F107,
    F108,
    F109,
    F110,
    F111,
    F113,
    F114,
    F115,
    F116,
    F117,
    F118,
    F119,
    F120,
    F121,
    F122,
    F123,
    F124,
    F125,
    F126,
    F127,
    F128,
    F129,
    F130,
    F132,
    F133,
    F134,
    F135,
    F136,
    F137,
    F140,
    F141,
    F142,
    F143,
    F144,
    F151,
    F152,
    F153,
    F165,
    F171,
    F172,
    F173,
    F174,
    F175,
    F177,
    F179,
    F199,
    F202,
    F203,
    F204,
    F206,
    F208,
    F209,
    F242,
    F243,
    F251,
    F252,
    F253,
    F254,
    F255,
    F256,
    F257,
    F258,
    F259,
    F260,
    F263,
    F264,
    F270,
    F271,
    F272,
    F280,
    F281,
    F301,
    F302,
    F303,
    F304,
    F305,
    F307,
    F311,
    F312,
    F313,
    F329,
    F330,
    F331,
    F332,
    F333,
    F334,
    F335,
    F336,
    F337,
    F338,
    F339,
    F340,
    F341,
    F342,
    F343,
    F344,
    F345,
    F346,
    F347,
    F348,
    F349,
    F401,
    F405,
    F421,
    F422,
    F423,
    F424,
    F425,
    F431,
    F432,
    F433,
    F434,
    F443,
    F451,
    F461,
    F503,
    F533,
    F619,
    F999;

    /**
    * Retrieves the field name associated with the enum constant.
    * The field name is the part of the enum constant name after the initial 'F'.
    *
    * @return the field name as a {@code String}
    * <p>
    * Example:
    *   FieldEnum field = FieldEnum.F11A;
    *   String fieldName = field.fieldName(); // returns "11A"
    */
    public String fieldName() {
        return name().substring(1); // Skips the first character 'F' and returns the rest of the name
    }

    /**
    * Converts a string field name into its corresponding {@code FieldEnum} constant.
    * The input should be the string representation of the field without the initial 'F'.
    *
    * @param fieldName the string field name (e.g., "11A", "12B")
    * @return the corresponding {@code FieldEnum} constant, or {@code null} if not found
    * <p>
    * Example:
    *   FieldEnum field = FieldEnum.fromFieldName("11A"); // returns FieldEnum.F11A
    *   FieldEnum unknownField = FieldEnum.fromFieldName("99Z"); // returns null
    */
    public static FieldEnum fromFieldName(String fieldName) {
        for (FieldEnum field : FieldEnum.values()) {
            if (field.fieldName().equals(fieldName)) {
                return field;
            }
        }
        return null;
    }
}
