/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31G
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31G";
    public static final String F_31G = "31G";
    @Deprecated
    public static final String PARSER_PATTERN = "<DATE2>/S/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "EHS";
    @Deprecated
    public static final String TYPES_PATTERN = "EHS";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;
    public static final Integer LOCATION = 3;

    public Field31G() {
        super(3);
    }

    public Field31G(String value) {
        super(value);
    }

    public Field31G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31G")) {
            throw new IllegalArgumentException("cannot create field 31G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31G newInstance(Field31G source) {
        Field31G cp = new Field31G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31G", value);
    }

    public static Tag emptyTag() {
        return new Tag("31G", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThirdLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31G");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "EHS";
    }

    @Override
    public String typesPattern() {
        return "EHS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<DATE2>/<HHMM>/12a";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        result.add("Location");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        result.put(3, "location");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("time", 2);
        this.labelMap.put("location", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent2();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent3();
    }

    public Field31G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31G setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field31G setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field31G setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field31G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31G setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field31G setTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field31G setTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field31G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field31G setLocation(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "31G";
    }

    public static Field31G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31G");
        if (t == null) {
            return null;
        }
        return new Field31G(t);
    }

    public static Field31G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31G.get(msg.getBlock4());
    }

    public static List<Field31G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31G.getAll(msg.getBlock4());
    }

    public static List<Field31G> getAll(SwiftTagListBlock block) {
        ArrayList<Field31G> result = new ArrayList<Field31G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("31G");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field31G(f));
            }
        }
        return result;
    }

    public static Field31G fromJson(String json) {
        Field31G field = new Field31G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("location") != null) {
            field.setComponent3(jsonObject.get("location").getAsString());
        }
        return field;
    }
}

