/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field29L
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "29L";
    public static final String F_29L = "29L";
    @Deprecated
    public static final String PARSER_PATTERN = "S/S/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "DSH";
    @Deprecated
    public static final String TYPES_PATTERN = "DSH";
    public static final Integer DATE = 1;
    public static final Integer LOCATION = 2;
    public static final Integer TIME = 3;

    public Field29L() {
        super(3);
    }

    public Field29L(String value) {
        super(value);
    }

    public Field29L(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"29L")) {
            throw new IllegalArgumentException("cannot create field 29L from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field29L newInstance(Field29L source) {
        Field29L cp = new Field29L();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("29L", value);
    }

    public static Tag emptyTag() {
        return new Tag("29L", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 29L");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "DSH";
    }

    @Override
    public String typesPattern() {
        return "DSH";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<DATE4>/4!c/<HHMM>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Location");
        result.add("Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "location");
        result.put(3, "time");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("location", 2);
        this.labelMap.put("time", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getLocation() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent3();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public Field29L setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29L setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field29L setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field29L setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field29L setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field29L setLocation(String component2) {
        return this.setComponent2(component2);
    }

    public Field29L setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field29L setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field29L setTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field29L setTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "29L";
    }

    public static Field29L get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("29L");
        if (t == null) {
            return null;
        }
        return new Field29L(t);
    }

    public static Field29L get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field29L.get(msg.getBlock4());
    }

    public static List<Field29L> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field29L.getAll(msg.getBlock4());
    }

    public static List<Field29L> getAll(SwiftTagListBlock block) {
        ArrayList<Field29L> result = new ArrayList<Field29L>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("29L");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field29L(f));
            }
        }
        return result;
    }

    public static Field29L fromJson(String json) {
        Field29L field = new Field29L();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("location") != null) {
            field.setComponent2(jsonObject.get("location").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent3(jsonObject.get("time").getAsString());
        }
        return field;
    }
}

