/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.MOR;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field254
extends Field
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "254";
    public static final String F_254 = "254";
    @Deprecated
    public static final String PARSER_PATTERN = "<MOR><MOR>[<HHMM><HHMM>]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "VVHH";
    @Deprecated
    public static final String TYPES_PATTERN = "VVHH";
    public static final Integer START_MOR = 1;
    public static final Integer END_MOR = 2;
    public static final Integer START_TIME = 3;
    public static final Integer END_TIME = 4;

    public Field254() {
        super(4);
    }

    public Field254(String value) {
        super(value);
    }

    public Field254(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"254")) {
            throw new IllegalArgumentException("cannot create field 254 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field254 newInstance(Field254 source) {
        Field254 cp = new Field254();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("254", value);
    }

    public static Tag emptyTag() {
        return new Tag("254", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            if (value.length() >= 28) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)28));
            }
            if (value.length() >= 56) {
                this.setComponent2(StringUtils.substring((String)value, (int)28, (int)56));
            }
            if (value.length() >= 60) {
                this.setComponent3(StringUtils.substring((String)value, (int)56, (int)60));
            }
            if (value.length() > 60) {
                this.setComponent4(StringUtils.substring((String)value, (int)60));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        SimpleDateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 254");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "VVHH";
    }

    @Override
    public String typesPattern() {
        return "VVHH";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Start MOR");
        result.add("End MOR");
        result.add("Start Time");
        result.add("End Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "startMOR");
        result.put(2, "endMOR");
        result.put(3, "startTime");
        result.put(4, "endTime");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("startmor", 1);
        this.labelMap.put("endmor", 2);
        this.labelMap.put("starttime", 3);
        this.labelMap.put("endtime", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public MOR getComponent1AsMOR() {
        return SwiftFormatUtils.getMOR(this.getComponent(1));
    }

    public String getStartMOR() {
        return this.getComponent1();
    }

    public MOR getStartMORAsMOR() {
        return this.getComponent1AsMOR();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public MOR getComponent2AsMOR() {
        return SwiftFormatUtils.getMOR(this.getComponent(2));
    }

    public String getEndMOR() {
        return this.getComponent2();
    }

    public MOR getEndMORAsMOR() {
        return this.getComponent2AsMOR();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent3();
    }

    public Calendar getStartTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getEndTime() {
        return this.getComponent4();
    }

    public Calendar getEndTimeAsCalendar() {
        return this.getComponent4AsCalendar();
    }

    public Field254 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field254 setComponent1(MOR component1) {
        this.setComponent(1, SwiftFormatUtils.getMOR(component1));
        return this;
    }

    public Field254 setStartMOR(String component1) {
        return this.setComponent1(component1);
    }

    public Field254 setStartMOR(MOR component1) {
        return this.setComponent1(component1);
    }

    public Field254 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field254 setComponent2(MOR component2) {
        this.setComponent(2, SwiftFormatUtils.getMOR(component2));
        return this;
    }

    public Field254 setEndMOR(String component2) {
        return this.setComponent2(component2);
    }

    public Field254 setEndMOR(MOR component2) {
        return this.setComponent2(component2);
    }

    public Field254 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field254 setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field254 setStartTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field254 setStartTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    public Field254 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field254 setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime3(component4));
        return this;
    }

    public Field254 setEndTime(String component4) {
        return this.setComponent4(component4);
    }

    public Field254 setEndTime(Calendar component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "254";
    }

    public static Field254 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("254");
        if (t == null) {
            return null;
        }
        return new Field254(t);
    }

    public static Field254 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field254.get(msg.getBlock4());
    }

    public static List<Field254> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field254.getAll(msg.getBlock4());
    }

    public static List<Field254> getAll(SwiftTagListBlock block) {
        ArrayList<Field254> result = new ArrayList<Field254>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("254");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field254(f));
            }
        }
        return result;
    }

    public static Field254 fromJson(String json) {
        Field254 field = new Field254();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("startMOR") != null) {
            field.setComponent1(jsonObject.get("startMOR").getAsString());
        }
        if (jsonObject.get("endMOR") != null) {
            field.setComponent2(jsonObject.get("endMOR").getAsString());
        }
        if (jsonObject.get("startTime") != null) {
            field.setComponent3(jsonObject.get("startTime").getAsString());
        }
        if (jsonObject.get("endTime") != null) {
            field.setComponent4(jsonObject.get("endTime").getAsString());
        }
        return field;
    }
}

