/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field119;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TestUtils {
    public static SwiftMessage createMT(int n) {
        SwiftMessage swiftMessage = new SwiftMessage(true);
        SwiftBlock2Input swiftBlock2Input = new SwiftBlock2Input();
        swiftBlock2Input.setMessageType("" + n);
        swiftBlock2Input.setInput(true);
        swiftBlock2Input.setMessagePriority("N");
        swiftBlock2Input.setDeliveryMonitoring("2");
        swiftBlock2Input.setObsolescencePeriod("020");
        swiftBlock2Input.setReceiverAddress("12345612XXXX");
        swiftMessage.setBlock2(swiftBlock2Input);
        return swiftMessage;
    }

    public static SwiftMessage createMT(int n, Tag ... tagArray) {
        SwiftMessage swiftMessage = TestUtils.createMT(n);
        if (tagArray != null && tagArray.length > 0) {
            for (Tag tag : tagArray) {
                swiftMessage.getBlock4().addTag(tag);
            }
        }
        return swiftMessage;
    }

    public static SwiftMessage createMT(int n, SwiftTagListBlock ... swiftTagListBlockArray) {
        SwiftMessage swiftMessage = TestUtils.createMT(n);
        if (swiftTagListBlockArray != null && swiftTagListBlockArray.length > 0) {
            for (SwiftTagListBlock swiftTagListBlock : swiftTagListBlockArray) {
                swiftMessage.getBlock4().getTags().addAll(swiftTagListBlock.getTags());
            }
        }
        return swiftMessage;
    }

    public static SwiftMessage addSeq(SwiftMessage swiftMessage, String string, Tag ... tagArray) {
        swiftMessage.getBlock4().addTag(new Tag("16R", string));
        if (tagArray != null && tagArray.length > 0) {
            for (Tag tag : tagArray) {
                swiftMessage.getBlock4().addTag(tag);
            }
        }
        swiftMessage.getBlock4().addTag(new Tag("16S", string));
        return swiftMessage;
    }

    public static SwiftMessage enclose(SwiftMessage swiftMessage, String string, Tag ... tagArray) {
        List<Tag> list = swiftMessage.getBlock4().getTags();
        list.add(0, new Tag("16R", string));
        if (tagArray != null && tagArray.length > 0) {
            for (int i = tagArray.length - 1; i >= 0; --i) {
                list.add(1, tagArray[i]);
            }
        }
        list.add(new Tag("16S", string));
        return swiftMessage;
    }

    public static SwiftMessage createMTwithEmptyTags(int n, String ... stringArray) {
        SwiftMessage swiftMessage = TestUtils.createMT(n, (Tag[])null);
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                swiftMessage.getBlock4().addTag(new Tag(string, "ignored"));
            }
        }
        return swiftMessage;
    }

    public static void setSTP(SwiftMessage swiftMessage) {
        SwiftBlock3 swiftBlock3 = swiftMessage.getBlock3();
        if (swiftBlock3 == null) {
            swiftMessage.addBlock(new SwiftBlock3());
        }
        if (swiftBlock3.containsTag("119")) {
            swiftBlock3.getTagByName("119").setValue("STP");
        } else {
            swiftBlock3.addTag(Field119.tag("STP"));
        }
    }

    public static Tag[] newSeq(String string, Tag ... tagArray) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        arrayList.add(new Tag("16R", string));
        if (tagArray != null && tagArray.length > 0) {
            for (Tag tag : tagArray) {
                arrayList.add(tag);
            }
        }
        arrayList.add(new Tag("16S", string));
        return arrayList.toArray(new Tag[arrayList.size()]);
    }

    public static void append(SwiftMessage swiftMessage, SwiftTagListBlock swiftTagListBlock) {
        Validate.notNull((Object)swiftMessage, (String)"message must not be null");
        Validate.notNull((Object)swiftTagListBlock, (String)"block must not be null");
        swiftMessage.getBlock4().append(swiftTagListBlock);
    }

    public static void readFile(String string) {
    }
}

