/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field33A;
import com.prowidesoftware.swift.model.field.Field33K;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field74;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT430
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "430";
    private static final transient Logger log = Logger.getLogger(MT430.class.getName());

    public MT430(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT430(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT430() {
        super(430);
    }

    public MT430(int n, String string, String string2) {
        super(430, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT430 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT430 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT430 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field59 getField59() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("59");
        if (tag == null) {
            log.fine("field 59 not found");
            return null;
        }
        return new Field59(tag.getValue());
    }

    public Field72 getField72() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("72");
        if (tag == null) {
            log.fine("field 72 not found");
            return null;
        }
        return new Field72(tag.getValue());
    }

    public Field74 getField74() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("74");
        if (tag == null) {
            log.fine("field 74 not found");
            return null;
        }
        return new Field74(tag.getValue());
    }

    public List<Field20> getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("20");
        ArrayList<Field20> arrayList = new ArrayList<Field20>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field20(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field21> getField21() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("21");
        ArrayList<Field21> arrayList = new ArrayList<Field21>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field21(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field32A> getField32A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("32A");
        ArrayList<Field32A> arrayList = new ArrayList<Field32A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field32A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field32K> getField32K() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("32K");
        ArrayList<Field32K> arrayList = new ArrayList<Field32K>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field32K(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field33A> getField33A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("33A");
        ArrayList<Field33A> arrayList = new ArrayList<Field33A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field33A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field33K> getField33K() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("33K");
        ArrayList<Field33K> arrayList = new ArrayList<Field33K>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field33K(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<SequenceA> getSequenceAList() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<SequenceA> arrayList = new ArrayList<SequenceA>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new SequenceA(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public SequenceB getSequenceB() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            SwiftTagListBlock swiftTagListBlock = swiftBlock4.getSubBlockAfterLast("20", false);
            if (swiftTagListBlock == null) {
                return null;
            }
            return new SequenceB(swiftTagListBlock);
        }
        return null;
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        public static final String[] END = new String[]{"21"};
        public static final String[] TAIL = new String[]{"32A", "32K", "33A", "33K"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static SequenceA newInstance(Tag ... tagArray) {
            return SequenceA.newInstance(0, 0, tagArray);
        }

        public static SequenceA newInstance(int n, int n2, Tag ... tagArray) {
            SequenceA sequenceA = new SequenceA();
            sequenceA.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequenceA.addTag(tag);
                }
            }
            sequenceA.addTag(new Tag(END[n2], ""));
            return sequenceA;
        }
    }
}

