/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21A;
import com.prowidesoftware.swift.model.field.Field21C;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field50D;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field71F;
import com.prowidesoftware.swift.model.field.Field77A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT416
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "416";
    private static final transient Logger log = Logger.getLogger(MT416.class.getName());

    public MT416(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT416(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT416() {
        super(416);
    }

    public MT416(int n, String string, String string2) {
        super(416, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT416 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT416 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT416 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field20 getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("20");
        if (tag == null) {
            log.fine("field 20 not found");
            return null;
        }
        return new Field20(tag.getValue());
    }

    public Field21 getField21() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("21");
        if (tag == null) {
            log.fine("field 21 not found");
            return null;
        }
        return new Field21(tag.getValue());
    }

    public Field51A getField51A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("51A");
        if (tag == null) {
            log.fine("field 51A not found");
            return null;
        }
        return new Field51A(tag.getValue());
    }

    public Field53A getField53A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("53A");
        if (tag == null) {
            log.fine("field 53A not found");
            return null;
        }
        return new Field53A(tag.getValue());
    }

    public Field53B getField53B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("53B");
        if (tag == null) {
            log.fine("field 53B not found");
            return null;
        }
        return new Field53B(tag.getValue());
    }

    public List<Field21A> getField21A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("21A");
        ArrayList<Field21A> arrayList = new ArrayList<Field21A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field21A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field23E> getField23E() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("23E");
        ArrayList<Field23E> arrayList = new ArrayList<Field23E>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field23E(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field21C> getField21C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("21C");
        ArrayList<Field21C> arrayList = new ArrayList<Field21C>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field21C(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field32A> getField32A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("32A");
        ArrayList<Field32A> arrayList = new ArrayList<Field32A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field32A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field32B> getField32B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("32B");
        ArrayList<Field32B> arrayList = new ArrayList<Field32B>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field32B(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field32K> getField32K() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("32K");
        ArrayList<Field32K> arrayList = new ArrayList<Field32K>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field32K(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field50D> getField50D() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("50D");
        ArrayList<Field50D> arrayList = new ArrayList<Field50D>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field50D(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field59> getField59() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("59");
        ArrayList<Field59> arrayList = new ArrayList<Field59>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field59(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field71F> getField71F() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("71F");
        ArrayList<Field71F> arrayList = new ArrayList<Field71F>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field71F(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field77A> getField77A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("77A");
        ArrayList<Field77A> arrayList = new ArrayList<Field77A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field77A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public SequenceA getSequenceA() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            SwiftTagListBlock swiftTagListBlock = swiftBlock4.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (swiftTagListBlock == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + swiftTagListBlock.tagNamesList());
                }
            }
            if (swiftTagListBlock == null) {
                return new SequenceA();
            }
            return new SequenceA(swiftTagListBlock);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<SequenceB> arrayList = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new SequenceB(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21A"};
        public static final String[] END = new String[]{"32A", "32B", "32K"};
        public static final String[] TAIL = new String[]{"50D", "59", "71F", "77A"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static SequenceB newInstance(Tag ... tagArray) {
            return SequenceB.newInstance(0, 0, tagArray);
        }

        public static SequenceB newInstance(int n, int n2, Tag ... tagArray) {
            SequenceB sequenceB = new SequenceB();
            sequenceB.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequenceB.addTag(tag);
                }
            }
            sequenceB.addTag(new Tag(END[n2], ""));
            return sequenceB;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        public static final String[] END = new String[]{"21"};
        public static final String[] TAIL = new String[]{"23E", "51A", "53A", "53B", "71F", "77A"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static SequenceA newInstance(Tag ... tagArray) {
            return SequenceA.newInstance(0, 0, tagArray);
        }

        public static SequenceA newInstance(int n, int n2, Tag ... tagArray) {
            SequenceA sequenceA = new SequenceA();
            sequenceA.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequenceA.addTag(tag);
                }
            }
            sequenceA.addTag(new Tag(END[n2], ""));
            return sequenceA;
        }
    }
}

