/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMT {
    private static final transient Logger log = Logger.getLogger(AbstractMT.class.getName());
    private SwiftMessage m;

    public AbstractMT(SwiftMessage swiftMessage) {
        this.m = swiftMessage;
    }

    public AbstractMT(MtSwiftMessage mtSwiftMessage) {
        this.m = mtSwiftMessage.getModelMessage();
    }

    public AbstractMT() {
        this.m = new SwiftMessage(true);
        if (this.getMessageType() != null) {
            this.m.getBlock2().setMessageType(this.getMessageType());
        }
    }

    public AbstractMT(int n) {
        this(n, "TESTUS00", "TESTUS00");
    }

    public AbstractMT(int n, String string, String string2) {
        this.m = new SwiftMessage(true);
        this.m.getBlock1().setSender(string);
        SwiftBlock2Input swiftBlock2Input = new SwiftBlock2Input();
        swiftBlock2Input.setMessageType(Integer.valueOf(n).toString());
        swiftBlock2Input.setInput(true);
        swiftBlock2Input.setMessagePriority("N");
        swiftBlock2Input.setReceiver(string2);
        this.m.setBlock2(swiftBlock2Input);
    }

    public SwiftMessage getSwiftMessage() {
        return this.m;
    }

    public void setSwiftMessage(SwiftMessage swiftMessage) {
        this.m = swiftMessage;
    }

    public String getApplicationId() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getApplicationId();
        }
        return null;
    }

    public String getServiceId() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getServiceId();
        }
        return null;
    }

    public String getLogicalTerminal() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getLogicalTerminal();
        }
        return null;
    }

    public String getSessionNumber() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getSessionNumber();
        }
        return null;
    }

    public String getSequenceNumber() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getSequenceNumber();
        }
        return null;
    }

    public String getMessagePriority() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock2() != null) {
            return this.m.getBlock2().getMessagePriority();
        }
        return null;
    }

    public boolean isInput() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock2() != null) {
            return this.m.getBlock2().isInput();
        }
        return false;
    }

    public boolean isOutput() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock2() != null) {
            return this.m.getBlock2().isOutput();
        }
        return false;
    }

    public void setSender(String string) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        this.getSwiftMessage().getBlock1().setSender(string);
    }

    public void setSender(BIC bIC) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        this.getSwiftMessage().getBlock1().setLogicalTerminal(bIC);
    }

    public String getSender() {
        if (this.getSwiftMessage() != null && this.getSwiftMessage().getBlock1() != null) {
            return this.getSwiftMessage().getBlock1().getLogicalTerminal();
        }
        return null;
    }

    public void setReceiver(String string) {
        SwiftBlock2 swiftBlock2;
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        if ((swiftBlock2 = this.getSwiftMessage().getBlock2()).isInput()) {
            ((SwiftBlock2Input)swiftBlock2).setReceiver(string);
        }
    }

    public void setReceiver(BIC bIC) {
        this.setReceiver(bIC.getBic11());
    }

    public String getReceiver() {
        if (this.getSwiftMessage() != null && this.getSwiftMessage().getBlock2() != null) {
            SwiftBlock2 swiftBlock2 = this.getSwiftMessage().getBlock2();
            if (swiftBlock2.isInput()) {
                return ((SwiftBlock2Input)swiftBlock2).getReceiverAddress();
            }
            return ((SwiftBlock2Output)swiftBlock2).getMIRLogicalTerminal();
        }
        return null;
    }

    public void addField(Field field) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage();
        }
        this.getSwiftMessage().getBlock4().add(field);
    }

    public String FIN() {
        this.m.removeEmptyBlocks();
        ConversionService conversionService = new ConversionService();
        return conversionService.getFIN(this.m);
    }

    public abstract String getMessageType();

    public List<SwiftTagListBlock> getSequenceList(String string) {
        String string2 = "getSequence" + string + "List";
        Object object = this.invokeHere(string2);
        return (List)object;
    }

    private Object invokeHere(String string) {
        try {
            Method method = this.getClass().getMethod(string, new Class[0]);
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            log.warning("An error occured while invoking " + string + " in " + this);
            return null;
        }
    }

    public SwiftTagListBlock getSequence(String string) {
        String string2 = "getSequence" + string;
        Object object = this.invokeHere(string2);
        return (SwiftTagListBlock)object;
    }

    public String toString() {
        return "AbstractMT [m=" + this.m + "]";
    }

    public static AbstractMT create(int n) {
        return AbstractMT.create(n, "TESTUS00", "TESTUS00");
    }

    public static AbstractMT create(int n, String string, String string2) {
        SwiftMessage swiftMessage = new SwiftMessage(true);
        SwiftBlock2Input swiftBlock2Input = new SwiftBlock2Input();
        swiftBlock2Input.setMessageType(Integer.valueOf(n).toString());
        swiftBlock2Input.setInput(true);
        swiftBlock2Input.setMessagePriority("N");
        swiftBlock2Input.setDeliveryMonitoring("2");
        swiftBlock2Input.setObsolescencePeriod("020");
        swiftMessage.setBlock2(swiftBlock2Input);
        AbstractMT abstractMT = swiftMessage.toMT();
        abstractMT.setSender(StringUtils.rightPad((String)string, (int)12, (char)'X'));
        abstractMT.setReceiver(StringUtils.rightPad((String)string2, (int)12, (char)'X'));
        return abstractMT;
    }

    public AbstractMT append(SwiftTagListBlock swiftTagListBlock) {
        Validate.notNull((Object)swiftTagListBlock);
        if (!swiftTagListBlock.isEmpty()) {
            this.b4().addTags(swiftTagListBlock.getTags());
        }
        return this;
    }

    public AbstractMT append(Tag ... tagArray) {
        Validate.notNull((Object)tagArray);
        if (tagArray.length > 0) {
            for (Tag tag : tagArray) {
                this.b4().addTag(tag);
            }
        }
        return this;
    }

    public AbstractMT append(Field ... fieldArray) {
        Validate.notNull((Object)fieldArray);
        if (fieldArray.length > 0) {
            for (Field field : fieldArray) {
                this.b4().add(field);
            }
        }
        return this;
    }

    private SwiftBlock4 b4() {
        if (this.m == null) {
            throw new IllegalStateException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.m.getBlock4();
        if (swiftBlock4 == null) {
            this.m.setBlock4(new SwiftBlock4());
            return this.m.getBlock4();
        }
        return swiftBlock4;
    }
}

