/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field92J
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92J";
    public static final String F_92J = "92J";
    public static final String PARSER_PATTERN = ":S/[S]/S/CN[/S]";
    public static final String COMPONENTS_PATTERN = "SSSCNS";

    public static Tag tag(String string) {
        return new Tag("92J", string);
    }

    public static Tag emptyTag() {
        return new Tag("92J", "");
    }

    public Field92J() {
        super(6);
    }

    public Field92J(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(string, "/"));
        String string2 = SwiftParseUtils.getTokenThirdLast(string, "/");
        this.setComponent3(SwiftParseUtils.getTokenFirst(string2, null, "/"));
        String string3 = SwiftParseUtils.getTokenSecond(string2, "/");
        this.setComponent6(SwiftParseUtils.getTokenThirdLast(string2, "/"));
        this.setComponent4(SwiftParseUtils.getAlphaPrefix(string3));
        this.setComponent5(SwiftParseUtils.getNumericSuffix(string3));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("/");
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        if (StringUtils.isNotEmpty((String)this.getComponent6())) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field92J setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field92J setQualifier(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public Field92J setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field92J setDataSourceScheme(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent(3);
    }

    public Field92J setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field92J setCode(String string) {
        this.setComponent(3, string);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrency() {
        return this.getComponent(4);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public Field92J setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field92J setComponent4(Currency currency) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field92J setCurrency(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field92J setCurrency(Currency currency) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent(5);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field92J setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field92J setComponent5(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field92J setAmount(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field92J setAmount(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public String getNarrative() {
        return this.getComponent(6);
    }

    public Field92J setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field92J setNarrative(String string) {
        this.setComponent(6, string);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 2) {
            return true;
        }
        return n == 6;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent3();
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "92J";
    }

    public static Field92J get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field92J)swiftTagListBlock.getFieldByName("92J");
    }

    public static Field92J get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field92J.get(swiftMessage.getBlock4());
    }

    public static List<Field92J> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field92J.getAll(swiftMessage.getBlock4());
    }

    public static List<Field92J> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("92J");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field92J> arrayList = new ArrayList<Field92J>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field92J)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

