/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field90F
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90F";
    public static final String F_90F = "90F";
    public static final String PARSER_PATTERN = ":S//S/SN/S/N";
    public static final String COMPONENTS_PATTERN = "SSCNSN";

    public static Tag tag(String string) {
        return new Tag("90F", string);
    }

    public static Tag emptyTag() {
        return new Tag("90F", "");
    }

    public Field90F() {
        super(6);
    }

    public Field90F(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, ":", "//"));
        String string2 = SwiftParseUtils.getTokenSecondLast(string, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(string2, "/"));
        String string3 = SwiftParseUtils.getTokenSecondLast(string2, "/");
        String string4 = SwiftParseUtils.getTokenFirst(string3, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(string4));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(string4));
        String string5 = SwiftParseUtils.getTokenSecondLast(string3, "/");
        this.setComponent5(SwiftParseUtils.getTokenFirst(string5, "/"));
        this.setComponent6(SwiftParseUtils.getTokenSecondLast(string5, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("//");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field90F setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field90F setQualifier(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field90F setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field90F setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field90F setComponent3(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field90F setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field90F setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field90F setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field90F setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field90F setComponent6(Number number) {
        this.setComponent(6, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent2();
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "90F";
    }

    public static Field90F get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field90F)swiftTagListBlock.getFieldByName("90F");
    }

    public static Field90F get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field90F.get(swiftMessage.getBlock4());
    }

    public static List<Field90F> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field90F.getAll(swiftMessage.getBlock4());
    }

    public static List<Field90F> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("90F");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field90F> arrayList = new ArrayList<Field90F>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field90F)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

