/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field60M
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "60M";
    public static final String F_60M = "60M";
    public static final String PARSER_PATTERN = "[c]<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "SECN";

    public static Tag tag(String string) {
        return new Tag("60M", string);
    }

    public static Tag emptyTag() {
        return new Tag("60M", "");
    }

    public Field60M() {
        super(4);
    }

    public Field60M(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
        String string2 = SwiftParseUtils.getNumericSuffix(string);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(string2));
        String string3 = SwiftParseUtils.getAlphaSuffix(string2);
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(string3));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(string3));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field60M setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field60M setDCMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field60M setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field60M setComponent2(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field60M setDate(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field60M setDate(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field60M setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field60M setComponent3(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field60M setCurrency(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field60M setCurrency(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field60M setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field60M setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field60M setAmount(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field60M setAmount(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return arrayList;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return n == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "60M";
    }

    public static Field60M get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field60M)swiftTagListBlock.getFieldByName("60M");
    }

    public static Field60M get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field60M.get(swiftMessage.getBlock4());
    }

    public static List<Field60M> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field60M.getAll(swiftMessage.getBlock4());
    }

    public static List<Field60M> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("60M");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field60M> arrayList = new ArrayList<Field60M>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field60M)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

