/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field56B
extends Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "56B";
    public static final String F_56B = "56B";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    public static final String COMPONENTS_PATTERN = "SSS";

    public static Tag tag(String string) {
        return new Tag("56B", string);
    }

    public static Tag emptyTag() {
        return new Tag("56B", "");
    }

    public Field56B() {
        super(3);
    }

    public Field56B(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            if (list.get(0).startsWith("/")) {
                if (list.get(0).startsWith("//")) {
                    this.setComponent1("");
                    this.setComponent2(StringUtils.substring((String)list.get(0), (int)2));
                } else {
                    String string2 = SwiftParseUtils.getTokenFirst(list.get(0), "/", "/");
                    if (StringUtils.isNotEmpty((String)string2)) {
                        if (string2.length() == 1) {
                            this.setComponent1(string2);
                            this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)list.get(0), (int)1), "/"));
                        } else {
                            this.setComponent2(StringUtils.substring((String)list.get(0), (int)1));
                        }
                    }
                }
                if (list.size() > 1) {
                    this.setComponent3(list.get(1));
                }
            } else {
                this.setComponent3(list.get(0));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.getComponent1() != null) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent1()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent2()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            if (bl) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field56B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field56B setDCMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String string = this.getComponent(2);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '/') continue;
                return string.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field56B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field56B setAccount(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent(3);
    }

    public Field56B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field56B setLocation(String string) {
        this.setComponent(3, string);
        return this;
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 1) {
            return true;
        }
        return n == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "56B";
    }

    public static Field56B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field56B)swiftTagListBlock.getFieldByName("56B");
    }

    public static Field56B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field56B.get(swiftMessage.getBlock4());
    }

    public static List<Field56B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field56B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field56B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("56B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field56B> arrayList = new ArrayList<Field56B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field56B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

