/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field35B
extends Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35B";
    public static final String F_35B = "35B";
    public static final String PARSER_PATTERN = "[ISIN S][$S]0-4";
    public static final String COMPONENTS_PATTERN = "SSSSSS";

    public static Tag tag(String string) {
        return new Tag("35B", string);
    }

    public static Tag emptyTag() {
        return new Tag("35B", "");
    }

    public Field35B() {
        super(6);
    }

    public Field35B(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0 && StringUtils.startsWith((String)list.get(0), (String)"ISIN ")) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(list.get(0), " "));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(list.get(0), " "));
            SwiftParseUtils.setComponentsFromLines(this, 3, 4, 1, list);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, 4, 0, list);
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getComponent1())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent1()) && StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append(" ");
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        this.appendInLines(stringBuilder, 3, 6);
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getIdentification() {
        return this.getComponent(1);
    }

    public Field35B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field35B setIdentification(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDescription() {
        return this.getComponent(2);
    }

    public Field35B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field35B setDescription(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field35B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field35B setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field35B setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public Field35B setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            return true;
        }
        if (n == 4) {
            return true;
        }
        if (n == 5) {
            return true;
        }
        return n == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "35B";
    }

    public static Field35B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field35B)swiftTagListBlock.getFieldByName("35B");
    }

    public static Field35B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field35B.get(swiftMessage.getBlock4());
    }

    public static List<Field35B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field35B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field35B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("35B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field35B> arrayList = new ArrayList<Field35B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field35B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

