/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field34E
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "34E";
    public static final String F_34E = "34E";
    public static final String PARSER_PATTERN = "[c]<CUR>N";
    public static final String COMPONENTS_PATTERN = "SCN";

    public static Tag tag(String string) {
        return new Tag("34E", string);
    }

    public static Tag emptyTag() {
        return new Tag("34E", "");
    }

    public Field34E() {
        super(3);
    }

    public Field34E(String string) {
        this();
        String string2 = SwiftParseUtils.getAlphaPrefix(string);
        if (string2 != null && string2.length() > 3) {
            this.setComponent1(StringUtils.substring((String)string2, (int)0, (int)1));
        }
        if (string2 != null) {
            if (string2.length() > 3) {
                this.setComponent1(StringUtils.substring((String)string2, (int)0, (int)1));
                this.setComponent2(StringUtils.substring((String)string2, (int)1, (int)string2.length()));
            } else {
                this.setComponent2(string2);
            }
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(string));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent(1);
    }

    public Field34E setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field34E setSign(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent(2);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field34E setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field34E setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field34E setCurrency(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field34E setCurrency(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field34E setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field34E setComponent3(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field34E setAmount(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field34E setAmount(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return n == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "34E";
    }

    public static Field34E get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field34E)swiftTagListBlock.getFieldByName("34E");
    }

    public static Field34E get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field34E.get(swiftMessage.getBlock4());
    }

    public static List<Field34E> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field34E.getAll(swiftMessage.getBlock4());
    }

    public static List<Field34E> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("34E");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field34E> arrayList = new ArrayList<Field34E>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field34E)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

