/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field33K
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33K";
    public static final String F_33K = "33K";
    public static final String PARSER_PATTERN = "cNS<CUR>N";
    public static final String COMPONENTS_PATTERN = "SNSCN";

    public static Tag tag(String string) {
        return new Tag("33K", string);
    }

    public static Tag emptyTag() {
        return new Tag("33K", "");
    }

    public Field33K() {
        super(5);
    }

    public Field33K(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
        String string2 = SwiftParseUtils.getNumericSuffix(string);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(string2));
        String string3 = SwiftParseUtils.getAlphaSuffix(string2);
        this.setComponent5(SwiftParseUtils.getNumericSuffix(string3));
        String string4 = SwiftParseUtils.getAlphaPrefix(string3);
        if (string4 != null && string4.length() >= 3) {
            this.setComponent4(StringUtils.substring((String)string4, (int)(string4.length() - 3), (int)string4.length()));
        }
        if (string4 != null && string4.length() >= 4) {
            this.setComponent3(StringUtils.substring((String)string4, (int)0, (int)(string4.length() - 3)));
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDMMark() {
        return this.getComponent(1);
    }

    public Field33K setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field33K setDMMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field33K setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field33K setComponent2(Number number) {
        this.setComponent(2, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field33K setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrency() {
        return this.getComponent(4);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public Field33K setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field33K setComponent4(Currency currency) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field33K setCurrency(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field33K setCurrency(Currency currency) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent(5);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field33K setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field33K setComponent5(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field33K setAmount(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field33K setAmount(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "33K";
    }

    public static Field33K get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field33K)swiftTagListBlock.getFieldByName("33K");
    }

    public static Field33K get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field33K.get(swiftMessage.getBlock4());
    }

    public static List<Field33K> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field33K.getAll(swiftMessage.getBlock4());
    }

    public static List<Field33K> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("33K");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field33K> arrayList = new ArrayList<Field33K>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field33K)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

