/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field32Q
extends Field
implements Serializable,
CurrencyContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32Q";
    public static final String F_32Q = "32Q";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "CC";

    public static Tag tag(String string) {
        return new Tag("32Q", string);
    }

    public static Tag emptyTag() {
        return new Tag("32Q", "");
    }

    public Field32Q() {
        super(2);
    }

    public Field32Q(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(string, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public Field32Q setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field32Q setComponent1(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field32Q setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field32Q setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "32Q";
    }

    public static Field32Q get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field32Q)swiftTagListBlock.getFieldByName("32Q");
    }

    public static Field32Q get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field32Q.get(swiftMessage.getBlock4());
    }

    public static List<Field32Q> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field32Q.getAll(swiftMessage.getBlock4());
    }

    public static List<Field32Q> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("32Q");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field32Q> arrayList = new ArrayList<Field32Q>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field32Q)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

