/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field31F
extends Field
implements Serializable,
DateContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31F";
    public static final String F_31F = "31F";
    public static final String PARSER_PATTERN = "<DATE2>[/<DATE2>][//S]";
    public static final String COMPONENTS_PATTERN = "EES";

    public static Tag tag(String string) {
        return new Tag("31F", string);
    }

    public static Tag emptyTag() {
        return new Tag("31F", "");
    }

    public Field31F() {
        super(3);
    }

    public Field31F(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, null, "/"));
        String string2 = SwiftParseUtils.getTokenSecondLast(string, "/");
        this.setComponent2(SwiftParseUtils.getTokenFirst(string2, "//"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(string2, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            stringBuilder.append("//");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public Field31F setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field31F setComponent1(Calendar calendar) {
        this.setComponent(1, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field31F setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field31F setComponent2(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field31F setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(1)));
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 2) {
            return true;
        }
        return n == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "31F";
    }

    public static Field31F get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field31F)swiftTagListBlock.getFieldByName("31F");
    }

    public static Field31F get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field31F.get(swiftMessage.getBlock4());
    }

    public static List<Field31F> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field31F.getAll(swiftMessage.getBlock4());
    }

    public static List<Field31F> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("31F");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field31F> arrayList = new ArrayList<Field31F>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field31F)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

