/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field19B
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "19B";
    public static final String F_19B = "19B";
    public static final String PARSER_PATTERN = ":S//SN";
    public static final String COMPONENTS_PATTERN = "SCN";

    public static Tag tag(String string) {
        return new Tag("19B", string);
    }

    public static Tag emptyTag() {
        return new Tag("19B", "");
    }

    public Field19B() {
        super(3);
    }

    public Field19B(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, ":", "//"));
        String string2 = SwiftParseUtils.getTokenSecondLast(string, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(string2));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(string2));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("//");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field19B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field19B setQualifier(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent(2);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field19B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field19B setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field19B setCurrency(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field19B setCurrency(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field19B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field19B setComponent3(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field19B setAmount(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field19B setAmount(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent2();
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "19B";
    }

    public static Field19B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field19B)swiftTagListBlock.getFieldByName("19B");
    }

    public static Field19B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field19B.get(swiftMessage.getBlock4());
    }

    public static List<Field19B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field19B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field19B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("19B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field19B> arrayList = new ArrayList<Field19B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field19B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

