/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.PatternContainer;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.time.DateFormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Field
implements PatternContainer {
    private static final transient Logger log = Logger.getLogger(Field.class.getName());
    protected List<String> components;

    @Deprecated
    protected Field() {
    }

    protected Field(int n) {
        this.components = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.components.add(null);
        }
    }

    public String toString() {
        try {
            return ToStringBuilder.reflectionToString((Object)this);
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)object);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    protected static String formatNumber(Object object) {
        DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(true);
            decimalFormat.setDecimalFormatSymbols(((DecimalFormat)numberFormat).getDecimalFormatSymbols());
        }
        String string = decimalFormat.format(object);
        return string;
    }

    protected static String format(Calendar calendar) {
        String string = "";
        try {
            string = DateFormatUtils.format((Date)calendar.getTime(), (String)"dd/MM/yyyy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected static String formatAccount(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        try {
            stringBuilder.insert(4, '-');
            stringBuilder.insert(9, '-');
            stringBuilder.insert(12, '-');
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    protected void appendInLines(StringBuilder stringBuilder, String ... stringArray) {
        Validate.notNull((Object)stringBuilder);
        if (stringArray == null) {
            log.finest("lines is null");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!StringUtils.isNotBlank((String)stringArray[i])) continue;
                if (i != 0 || i == 0 && StringUtils.isNotBlank((String)stringBuilder.toString())) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(stringArray[i]);
            }
        }
    }

    protected void appendInLines(StringBuilder stringBuilder, int n, int n2) {
        Validate.notNull((Object)stringBuilder);
        boolean bl = true;
        for (int i = n; i <= n2; ++i) {
            String string = this.getComponent(i);
            if (!StringUtils.isNotBlank((String)string)) continue;
            if (!bl || bl && StringUtils.isNotBlank((String)stringBuilder.toString())) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(string);
            bl = false;
        }
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> list) {
        this.components = list;
    }

    public void setComponent(int n, String string) {
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"component number is 1-based");
        int n2 = n - 1;
        if (this.components == null) {
            this.components = new ArrayList<String>();
        }
        if (n2 >= 0) {
            if (n2 < this.components.size()) {
                this.components.set(n2, string);
            }
        } else {
            log.severe("components are named starting at 1, cannot insert a component with number " + n);
        }
    }

    public String getComponent(int n) {
        int n2 = n - 1;
        if (this.components != null && n2 >= 0 && n2 < this.components.size()) {
            return this.components.get(n2);
        }
        return null;
    }

    public String getValueDisplay() {
        return null;
    }

    public Object getComponentAs(int n, Class clazz) {
        try {
            String string = this.getComponent(n);
            log.finest("converting string value: " + string);
            if (clazz.equals(String.class)) {
                return string;
            }
            if (clazz.equals(Number.class) || clazz.equals(BigDecimal.class)) {
                return SwiftFormatUtils.getNumber(string);
            }
            if (clazz.equals(BIC.class)) {
                return new BIC(string);
            }
            if (clazz.equals(Currency.class)) {
                return Currency.getInstance(string);
            }
            if (clazz.equals(Character.class)) {
                return SwiftFormatUtils.getSign(string);
            }
            if (clazz.equals(Integer.class)) {
                return Integer.valueOf(string);
            }
            throw new IllegalAccessException("Can't handle " + clazz.getName());
        }
        catch (Exception exception) {
            log.severe("Error converting component content: " + exception);
            return null;
        }
    }

    public String joinComponents(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            String string = "";
            for (int i = n; i < this.components.size() && StringUtils.isNotEmpty((String)this.components.get(i)); ++i) {
                stringBuffer.append(string);
                string = this.components.get(i);
            }
            if (!bl) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String joinComponents(boolean bl) {
        return this.joinComponents(0, bl);
    }

    public String joinComponents(int n) {
        return this.joinComponents(n, false);
    }

    public String joinComponents() {
        return this.joinComponents(0, false);
    }

    public static BigDecimal getAsBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof Short) {
            return new BigDecimal(((Short)number).intValue());
        }
        if (number instanceof Double) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("class " + number.getClass().getName() + " is not supported");
    }

    public String findComponentStartingWith(String string) {
        for (int i = 0; i < this.components.size(); ++i) {
            String string2 = this.components.get(i);
            if (!StringUtils.startsWith((String)string2, (String)string)) continue;
            return string2;
        }
        return null;
    }

    public String getValueByCodeword(String string) {
        String string2 = "/" + string + "/";
        String string3 = this.findComponentStartingWith(string2);
        if (string3 != null) {
            return StringUtils.substringAfter((String)string3, (String)string2);
        }
        return null;
    }

    public String getValue() {
        return this.joinComponents();
    }

    public boolean isEmpty() {
        for (String string : this.getComponents()) {
            if (string == null || !StringUtils.isNotBlank((String)string)) continue;
            return false;
        }
        return true;
    }

    public static Field getField(Tag tag) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName("com.prowidesoftware.swift.model.field.Field" + tag.getName());
            Class[] classArray = new Class[]{String.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{tag.getValue()};
            var1_1 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            log.warning("Error creating an instance of Field" + tag.getName() + " MISSING FIELD CLASS: " + exception);
        }
        return var1_1;
    }

    public String getLabel() {
        return this.getLabel(Locale.getDefault());
    }

    public String getLabel(Locale locale) {
        return Field.getLabel(this.getName(), locale);
    }

    public static String getLabel(String string, Locale locale) {
        return Field.getLabel(string, null, null, locale);
    }

    public static String getLabel(String string, String string2, String string3, Locale locale) {
        String string4 = null;
        String string5 = null;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("pw_swift_labels", locale);
        if (resourceBundle != null) {
            if (string3 != null && string2 != null && (string5 = Field.getString(resourceBundle, string4 = "field" + string + "[" + string2 + "][" + string3 + "].name")) == null) {
                string4 = "field" + Field.getNumber(string) + "a[" + string2 + "][" + string3 + "].name";
                string5 = Field.getString(resourceBundle, string4);
            }
            if (string5 == null && string2 != null && (string5 = Field.getString(resourceBundle, string4 = "field" + string + "[" + string2 + "][" + string3 + "].name")) == null) {
                string4 = "field" + Field.getNumber(string) + "a[" + string2 + "].name";
                string5 = Field.getString(resourceBundle, string4);
            }
            if (string5 == null && (string5 = Field.getString(resourceBundle, string4 = "field" + string + ".name")) == null) {
                string4 = "field" + Field.getNumber(string) + "a.name";
                string5 = Field.getString(resourceBundle, string4);
            }
            if (string5 == null) {
                string4 = "field" + Field.getNumber(string) + ".name";
                string5 = Field.getString(resourceBundle, string4);
            }
        }
        if (string5 != null) {
            return string5;
        }
        return string4;
    }

    private static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String getNumber(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c)) continue;
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public abstract String getName();

    public abstract boolean isOptional(int var1);

    public abstract boolean isGeneric();

    @Deprecated
    public String getDSS() {
        return null;
    }

    @Deprecated
    public boolean isDSSPresent() {
        return false;
    }

    @Deprecated
    public String getConditionalQualifier() {
        return null;
    }

    public Character letterOption() {
        String string = this.getClass().getName();
        char c = string.charAt(string.length() - 1);
        if (Character.isLetter(c)) {
            return Character.valueOf(c);
        }
        return null;
    }

    public boolean isLetterOption(char c) {
        Character c2 = this.letterOption();
        if (c2 != null) {
            return c2.charValue() == c;
        }
        return false;
    }

    public boolean isAnyOf(String ... stringArray) {
        Validate.isTrue((stringArray != null && stringArray.length > 0 ? 1 : 0) != 0, (String)"name list must have at least one element");
        for (String string : stringArray) {
            if (!StringUtils.equals((String)this.getName(), (String)string)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameAnyOf(String ... stringArray) {
        Validate.isTrue((stringArray != null && stringArray.length > 0 ? 1 : 0) != 0, (String)"name list must have at least one element");
        for (String string : stringArray) {
            if (!StringUtils.equals((String)this.getName(), (String)string)) continue;
            return true;
        }
        return false;
    }

    public boolean is(String string) {
        return StringUtils.equals((String)string, (String)this.getComponent(1));
    }

    public boolean is(int n, String string) {
        return StringUtils.equals((String)string, (String)this.getComponent(n));
    }

    public boolean is(String string, String string2) {
        return StringUtils.equals((String)string, (String)this.getComponent(1)) && StringUtils.equals((String)string2, (String)this.getComponent(2));
    }

    public Tag asTag() {
        return new Tag(this.getName(), this.getValue());
    }
}

