/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnparsedTextList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private List<String> texts = new ArrayList<String>();

    public UnparsedTextList() {
    }

    public UnparsedTextList(Collection<String> collection) {
        Validate.notNull(collection, (String)"parameter 'texts' cannot be null");
        Validate.allElementsOfType(collection, String.class, (String)"parameter 'texts' may only have String elements");
        this.texts = new ArrayList<String>(collection);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getAsFINString() {
        if (this.texts.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.texts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Boolean isMessage(String string) {
        return string != null && string.indexOf("{1:") >= 0;
    }

    public List<String> getTexts() {
        return this.texts;
    }

    protected void setTexts(List<String> list) {
        this.texts = list;
    }

    public Integer size() {
        return new Integer(this.texts.size());
    }

    public Boolean isMessage(Integer n) {
        return UnparsedTextList.isMessage(this.getText(n));
    }

    public String getText(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'index' cannot be null");
        return this.texts.get(n);
    }

    public SwiftMessage getTextAsMessage(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'index' cannot be null");
        ConversionService conversionService = new ConversionService();
        return conversionService.getMessageFromFIN(this.texts.get(n));
    }

    public void addText(String string) {
        Validate.notNull((Object)string, (String)"parameter 'text' cannot be null");
        this.texts.add(string);
    }

    public void addText(SwiftMessage swiftMessage) {
        Validate.notNull((Object)swiftMessage, (String)"parameter 'message' cannot be null");
        ConversionService conversionService = new ConversionService();
        String string = conversionService.getFIN(swiftMessage);
        this.addText(string);
    }

    public void removeText(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'index' cannot be null");
        this.texts.remove(n);
    }

    public void removeText(int n) {
        this.texts.remove(n);
    }

    public void removeText(String string) {
        Validate.notNull((Object)string, (String)"parameter 'text' cannot be null");
        int n = this.texts.indexOf(string);
        if (n != -1) {
            this.texts.remove(n);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.texts == null ? 0 : ((Object)this.texts).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnparsedTextList unparsedTextList = (UnparsedTextList)object;
        return !(this.texts == null ? unparsedTextList.texts != null : !((Object)this.texts).equals(unparsedTextList.texts));
    }
}

