/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SequenceNode;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Long id;
    protected Integer sortKey;
    protected String name;
    protected String value;
    protected UnparsedTextList unparsedTexts = null;
    protected SequenceNode sequence = null;

    public Tag() {
    }

    public Tag(String string) {
        Validate.notNull((Object)string, (String)"parameter 'inner' cannot be null");
        int n = string.indexOf(58);
        if (n >= 0) {
            if (n > 0) {
                this.name = string.substring(0, n);
            }
            if (n + 1 < string.length()) {
                this.value = string.substring(n + 1);
            }
        } else if (string.length() > 0) {
            this.value = string;
        }
    }

    public Tag(String string, String string2) {
        Validate.notNull((Object)string, (String)"parameter 'tagname' cannot be null");
        Validate.notNull((Object)string2, (String)"parameter 'value' cannot be null");
        this.name = string;
        this.value = string2;
    }

    public Tag(UnparsedTextList unparsedTextList) {
        this();
        this.unparsedTexts = unparsedTextList;
    }

    public Tag(String string, UnparsedTextList unparsedTextList) {
        this(string);
        this.unparsedTexts = unparsedTextList;
    }

    public Tag(String string, String string2, UnparsedTextList unparsedTextList) {
        this(string, string2);
        this.unparsedTexts = unparsedTextList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'name' cannot be null");
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return "Tag[" + this.name + ":" + this.value + "]";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public Integer getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(Integer n) {
        this.sortKey = n;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList unparsedTextList) {
        this.unparsedTexts = unparsedTextList;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(n);
    }

    public String unparsedTextGetText(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(n);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(n);
    }

    public void unparsedTextAddText(String string) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(string);
    }

    public void unparsedTextAddText(SwiftMessage swiftMessage) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(swiftMessage);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        n = 31 * n + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tag tag = (Tag)object;
        if (this.name == null ? tag.name != null : !this.name.equals(tag.name)) {
            return false;
        }
        if (this.sortKey == null ? tag.sortKey != null : !this.sortKey.equals(tag.sortKey)) {
            return false;
        }
        if (this.unparsedTexts == null ? tag.unparsedTexts != null : !this.unparsedTexts.equals(tag.unparsedTexts)) {
            return false;
        }
        return !(this.value == null ? tag.value != null : !this.value.equals(tag.value));
    }

    public int getNameAsInt() {
        try {
            return Integer.valueOf(this.name);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean isNumber(int n) {
        return this.name != null && this.getNumber() != null && this.getNumber().equals(n);
    }

    public Integer getNumber() {
        if (this.name != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isDigit(c)) continue;
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                return Integer.parseInt(stringBuffer.toString());
            }
        }
        return null;
    }

    public String getLetterOption() {
        if (this.name != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isLetter(c)) continue;
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public Field getField() {
        return Field.getField(this);
    }

    public boolean contains(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String string = this.getValue();
            for (String string2 : stringArray) {
                if (!StringUtils.contains((String)string, (String)string2)) continue;
                return true;
            }
        }
        return false;
    }

    public void setNameValue(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public boolean startsWith(String string) {
        return StringUtils.startsWith((String)this.getValue(), (String)string);
    }

    public boolean contains(String string) {
        return StringUtils.contains((String)this.getValue(), (String)string);
    }

    public Field asField() {
        try {
            return Field.getField(this);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

