/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.TagVisitor;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftTagListBlock
extends SwiftBlock
implements Serializable,
Iterable<Tag> {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(SwiftTagListBlock.class.getName());
    protected List<Tag> tags = new ArrayList<Tag>();

    public SwiftTagListBlock() {
    }

    public SwiftTagListBlock(List<Tag> list) {
        this();
        this.tags = list;
    }

    public boolean containsTag(String string) {
        Validate.notNull((Object)string, (String)"parameter 'tagName' cannot not be null");
        for (Tag tag : this.tags) {
            if (tag.getName() == null || !tag.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getTagValue(String string) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        Tag tag = this.getTagByName(string);
        return tag != null ? tag.getValue() : null;
    }

    public Tag getTagByName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        for (Tag tag : this.tags) {
            if (tag.getName() == null || !tag.getName().equals(string)) continue;
            return tag;
        }
        return null;
    }

    public Field getFieldByName(String string, String string2, String string3) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        for (Tag tag : this.tags) {
            Field field;
            if (tag.getName() == null || !tag.getName().equals(string) || !(field = tag.getField()).is(string2) || !StringUtils.equals((String)field.getComponent(2), (String)string3)) continue;
            return field;
        }
        return null;
    }

    public Field getFieldByName(String string, String string2) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        for (Tag tag : this.tags) {
            Field field;
            if (tag.getName() == null || !tag.getName().equals(string) || !(field = tag.getField()).is(string2)) continue;
            return field;
        }
        return null;
    }

    public Field getFieldByName(String string) {
        Tag tag = this.getTagByName(string);
        if (tag != null) {
            return tag.getField();
        }
        return null;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void addTag(Tag tag) {
        Validate.notNull((Object)tag, (String)"parameter 't' cannot not be null");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding Tag [" + tag + "]");
        }
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tag);
    }

    public void add(Field field) {
        this.addTag(new Tag(field.getName(), field.getValue()));
    }

    public int getTagCount(String string) {
        return this.countByName(string);
    }

    public int countByName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        int n = 0;
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                if (!tag.getName().equals(string)) continue;
                ++n;
            }
        }
        return n;
    }

    public String[] getTagValues(String string) {
        Validate.notNull((Object)string, (String)"parameter 'key' cannot not be null");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                if (!tag.getName().equals(string)) continue;
                arrayList.add(tag.getValue());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (this.tags == null ? "tags=null" : this.tags.toString()) + "]";
    }

    public Map<String, String> getTagMap() {
        if (this.tags != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.tags.size());
            for (Tag tag : this.tags) {
                if (hashMap.containsKey(tag.getName())) continue;
                hashMap.put(tag.getName(), tag.getValue());
            }
            return hashMap;
        }
        return null;
    }

    public String removeTag(String string) {
        Validate.notNull((Object)string, (String)"parameter 'tag' cannot not be null");
        if (this.tags != null) {
            int n = 0;
            for (Tag tag : this.tags) {
                if (tag.getName() != null && tag.getName().equals(string)) {
                    Tag tag2 = this.tags.remove(n);
                    return tag2.getValue();
                }
                ++n;
            }
        }
        return null;
    }

    public int removeAll(String string) {
        Validate.notNull((Object)string, (String)"parameter 'name' cannot not be null");
        int n = 0;
        Tag[] tagArray = this.getTagsByName(string);
        for (int i = 0; i < tagArray.length; ++i) {
            this.tags.remove(tagArray[i]);
            ++n;
        }
        return n;
    }

    public Tag[] getTagsByName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'name' cannot not be null");
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (tag.getName() == null && string == null) {
                arrayList.add(tag);
            }
            if (tag.getName() == null || string == null || !tag.getName().equals(string)) continue;
            arrayList.add(tag);
        }
        return arrayList.toArray(new Tag[arrayList.size()]);
    }

    public Field[] getFieldsByName(String string) {
        String string2;
        boolean bl;
        Validate.notNull((Object)string, (String)"parameter 'name' cannot not be null");
        if (string.endsWith("a")) {
            bl = true;
            string2 = string.substring(0, string.length() - 1);
        } else {
            bl = false;
            string2 = string;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Tag tag : this.tags) {
            if ((!bl || !StringUtils.startsWith((String)tag.getName(), (String)string2)) && !StringUtils.equals((String)tag.getName(), (String)string)) continue;
            Field field = tag.getField();
            if (field == null) {
                log.warning("Could not create field instance of " + tag);
                continue;
            }
            arrayList.add(field);
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    public List<? extends Field> getFieldsByName(String string, String string2) {
        String string3;
        boolean bl;
        Validate.notNull((Object)string, (String)"parameter 'name' cannot not be null");
        Validate.notNull((Object)string2, (String)"parameter 'being' cannot not be null");
        if (string.endsWith("a")) {
            bl = true;
            string3 = string.substring(0, string.length() - 1);
        } else {
            bl = false;
            string3 = string;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Tag tag : this.tags) {
            if ((!bl || !StringUtils.startsWith((String)tag.getName(), (String)string3)) && !StringUtils.equals((String)tag.getName(), (String)string)) continue;
            Field field = tag.getField();
            if (field == null) {
                log.warning("Could not create field instance of " + tag);
                continue;
            }
            if (!field.is(string2)) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    public Iterator<Tag> tagIterator() {
        if (this.tags == null || this.tags.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No tags in block, returning empty iterator");
            }
            return new EmptyItr();
        }
        return this.tags.iterator();
    }

    public Tag getTag(int n) {
        return this.tags.get(n);
    }

    public Field getField(int n) {
        return this.tags.get(n).getField();
    }

    public void addTags(List<Tag> list) {
        Validate.notNull(list, (String)"parameter 'tags' cannot not be null");
        Validate.allElementsOfType(list, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.thisTagsNotNull().addAll(list);
    }

    private List<Tag> thisTagsNotNull() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public int getTagCount() {
        return this.countAll();
    }

    public int countAll() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public void setTags(List<Tag> list) {
        if (list != null) {
            Validate.allElementsOfType(list, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        }
        this.tags = list;
    }

    public void setTags(Tag[] tagArray) {
        this.setTags(Arrays.asList(tagArray));
    }

    public boolean isEmpty() {
        return this.tags == null || this.tags.isEmpty();
    }

    public int size() {
        return this.tags == null ? 0 : this.tags.size();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftTagListBlock swiftTagListBlock = (SwiftTagListBlock)object;
        return !(this.tags == null ? swiftTagListBlock.tags != null : !((Object)this.tags).equals(swiftTagListBlock.tags));
    }

    public boolean containsTag(int n) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        for (Tag tag : this.tags) {
            if (!tag.isNumber(n)) continue;
            return true;
        }
        return false;
    }

    public Tag getTagByNumber(int n) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (Tag tag : this.tags) {
                if (!tag.isNumber(n)) continue;
                return tag;
            }
        }
        return null;
    }

    public Field getFieldByNumber(int n) {
        Tag tag = this.getTagByNumber(n);
        if (tag != null) {
            return tag.getField();
        }
        return null;
    }

    public List<Tag> getTagsByNumber(int n) {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!tag.isNumber(n)) continue;
            arrayList.add(tag);
        }
        return arrayList;
    }

    public List<? extends Field> getFieldsByNumber(int n) {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Tag tag : this.tags) {
            if (!tag.isNumber(n)) continue;
            Field field = tag.getField();
            if (field == null) {
                throw new RuntimeException("Unable to create field for tagname " + tag.getName());
            }
            arrayList.add(field);
        }
        return arrayList;
    }

    public Field getFieldByNumber(int n, String string) {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        for (Tag tag : this.tags) {
            if (!tag.isNumber(n)) continue;
            Field field = tag.getField();
            if (field == null) {
                throw new RuntimeException("Unable to create field for tagname " + tag.getName());
            }
            if (!field.is(string)) continue;
            return field;
        }
        return null;
    }

    public List<Tag> getTagsByValue(String string) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (!StringUtils.equals((String)string, (String)tag.getValue())) continue;
            arrayList.add(tag);
        }
        return arrayList;
    }

    public List<Tag> getTagsByContent(String string) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (!StringUtils.contains((String)tag.getValue(), (String)string)) continue;
            arrayList.add(tag);
        }
        return arrayList;
    }

    public List<SwiftTagListBlock> getSubBlocks(Tag tag, Tag tag2) {
        ArrayList<SwiftTagListBlock> arrayList = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock swiftTagListBlock = null;
        boolean bl = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag3 = this.tags.get(i);
            if (bl) {
                swiftTagListBlock.addTag(tag3);
                if (tag2 == null || !tag2.equals(tag3)) continue;
                arrayList.add(swiftTagListBlock);
                bl = false;
                swiftTagListBlock = null;
                continue;
            }
            if (!tag.equals(tag3)) continue;
            swiftTagListBlock = new SwiftTagListBlock();
            swiftTagListBlock.addTag(tag3);
            bl = true;
        }
        if (swiftTagListBlock != null) {
            arrayList.add(swiftTagListBlock);
        }
        return arrayList;
    }

    public SwiftTagListBlock getSubBlock(Tag tag, Tag tag2) {
        List<SwiftTagListBlock> list = this.getSubBlocks(tag, tag2);
        if (list.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return list.get(0);
    }

    public List<SwiftTagListBlock> getSubBlocks(String string, String string2) {
        Tag tag = new Tag(string, "");
        Tag tag2 = new Tag(string2, "");
        return this._getSubBlocks(tag.getNumber(), tag.getLetterOption(), tag2.getNumber(), tag2.getLetterOption());
    }

    public List<SwiftTagListBlock> getSubBlocks(int n, int n2) {
        return this._getSubBlocks(n, null, n2, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(String string, int n) {
        Tag tag = new Tag(string, "");
        return this._getSubBlocks(tag.getNumber(), tag.getLetterOption(), n, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(int n, String string) {
        Tag tag = new Tag(string, "");
        return this._getSubBlocks(n, null, tag.getNumber(), tag.getLetterOption());
    }

    private List<SwiftTagListBlock> _getSubBlocks(int n, String string, int n2, String string2) {
        ArrayList<SwiftTagListBlock> arrayList = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock swiftTagListBlock = null;
        boolean bl = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (bl) {
                swiftTagListBlock.addTag(tag);
                if ((string2 == null || !StringUtils.equals((String)tag.getName(), (String)(n2 + string2))) && (string2 != null || !tag.isNumber(n2))) continue;
                arrayList.add(swiftTagListBlock);
                bl = false;
                swiftTagListBlock = null;
                continue;
            }
            if ((string == null || !StringUtils.equals((String)tag.getName(), (String)(n + string))) && (string != null || !tag.isNumber(n))) continue;
            swiftTagListBlock = new SwiftTagListBlock();
            swiftTagListBlock.addTag(tag);
            bl = true;
        }
        if (swiftTagListBlock != null) {
            arrayList.add(swiftTagListBlock);
        }
        return arrayList;
    }

    public SwiftTagListBlock getSubBlockByIndex(Integer n, Integer n2) {
        return new SwiftTagListBlock(this.tags.subList(n == null ? 0 : n, n2 == null ? this.tags.size() : n2.intValue()));
    }

    public Integer getTagIndex(String string, String[] stringArray) {
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (!StringUtils.startsWith((String)tag.getName(), (String)string)) continue;
            if (stringArray == null || stringArray.length < 1) {
                return i;
            }
            for (String string2 : stringArray) {
                if (!StringUtils.equals((String)tag.getName(), (String)(string + string2))) continue;
                return i;
            }
        }
        return null;
    }

    public SwiftTagListBlock getSubBlock(String string, String string2) {
        List<SwiftTagListBlock> list = this.getSubBlocks(string, string2);
        if (list.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return list.get(0);
    }

    public List<SwiftTagListBlock> getSubBlocks(String string) {
        return this.getSubBlocks(new Tag("16R", string), new Tag("16S", string));
    }

    public SwiftTagListBlock getSubBlock(String string) {
        return this.getSubBlock(new Tag("16R", string), new Tag("16S", string));
    }

    public boolean containsTag(Tag tag) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        Iterator<Tag> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            if (!tag.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getNumber() {
        return null;
    }

    @Override
    protected void setBlockName(String string) {
    }

    @Override
    protected void setBlockNumber(Integer n) {
    }

    public void visit(TagVisitor tagVisitor) {
        if (tagVisitor != null && this.tags != null && !this.tags.isEmpty()) {
            for (Tag tag : this.tags) {
                tagVisitor.onTag(tag);
            }
        }
    }

    public List<SwiftTagListBlock> splitByTagName(String string) {
        ArrayList<SwiftTagListBlock> arrayList = new ArrayList<SwiftTagListBlock>();
        if (this.tags.isEmpty() || !this.containsTag(string)) {
            arrayList.add(this);
        } else {
            SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
            swiftTagListBlock.addTag(this.tags.get(0));
            for (int i = 1; i < this.tags.size(); ++i) {
                Tag tag = this.tags.get(i);
                if (StringUtils.equals((String)string, (String)tag.getName())) {
                    arrayList.add(swiftTagListBlock);
                    swiftTagListBlock = new SwiftTagListBlock();
                }
                swiftTagListBlock.addTag(tag);
            }
            if (!arrayList.contains(swiftTagListBlock)) {
                arrayList.add(swiftTagListBlock);
            }
        }
        return arrayList;
    }

    public boolean containsField(String string) {
        Field[] fieldArray = this.getFieldsByName(string);
        return fieldArray != null && fieldArray.length > 0;
    }

    public SwiftTagListBlock getSubBlockAfterFirst(String string, boolean bl) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        if (this.tags != null && this.tags.size() > 0) {
            boolean bl2 = false;
            for (int i = 0; i < this.tags.size(); ++i) {
                boolean bl3 = false;
                Tag tag = this.tags.get(i);
                if (StringUtils.equals((String)string, (String)tag.getName())) {
                    bl2 = true;
                    bl3 = true;
                }
                if ((!bl2 || bl3) && (!bl3 || !bl)) continue;
                swiftTagListBlock.addTag(tag);
            }
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock getSubBlockAfterFirst(String string) {
        return this.getSubBlockAfterFirst(string, true);
    }

    public SwiftTagListBlock getSubBlockBeforeFirst(String string, boolean bl) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        if (this.tags != null && this.tags.size() > 0) {
            Iterator<Tag> iterator = this.tags.iterator();
            boolean bl2 = false;
            while (iterator.hasNext() && !bl2) {
                Tag tag = iterator.next();
                if (StringUtils.equals((String)string, (String)tag.getName())) {
                    if (bl) {
                        swiftTagListBlock.addTag(tag);
                    }
                    bl2 = true;
                    continue;
                }
                swiftTagListBlock.addTag(tag);
            }
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock getSubBlockAfterLast(String string, boolean bl) {
        int n = this.indexOfLast(string);
        if (n >= 0) {
            if (bl) {
                return this.getSubBlock(n, null);
            }
            if (n < this.tags.size()) {
                return this.getSubBlock(n + 1, null);
            }
        }
        return null;
    }

    public SwiftTagListBlock getSubBlock(Integer n, Integer n2) {
        int n3;
        int n4 = n == null ? 0 : n;
        int n5 = n3 = n2 == null || n2 > this.tags.size() - 1 ? this.tags.size() : n2.intValue();
        if (n4 >= n3) {
            throw new IllegalArgumentException("from (" + n4 + ") is equal or bigger than to (" + n3 + ")");
        }
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        swiftTagListBlock.addTags(this.tags.subList(n4, n3));
        return swiftTagListBlock;
    }

    public int indexOfLast(String string) {
        int n = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                n = i;
            }
        }
        return n;
    }

    public int indexOfAnyLast(String ... stringArray) {
        int n = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String string : stringArray) {
                    if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                    n = i;
                }
            }
        }
        return n;
    }

    public int indexOfAnyLastAfterIndex(int n, String ... stringArray) {
        int n2 = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = n; i < this.tags.size(); ++i) {
                for (String string : stringArray) {
                    if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                    n2 = i;
                }
            }
        }
        return n2;
    }

    public int indexOfFirst(String string) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfAnyFirst(String ... stringArray) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String string : stringArray) {
                    if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int indexOfAnyFirstAfterIndex(int n, String ... stringArray) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = n; i < this.tags.size(); ++i) {
                for (String string : stringArray) {
                    if (!StringUtils.equals((String)string, (String)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public SwiftTagListBlock getSubBlockBeforeLast(String string, boolean bl) {
        int n = this.indexOfLast(string);
        if (bl && n > 0) {
            return this.getSubBlock(null, n + 1);
        }
        if (!bl && n > 0) {
            return this.getSubBlock(null, n);
        }
        return null;
    }

    public SwiftTagListBlock trimAfterFirst(String string, boolean bl) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        boolean bl2 = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            boolean bl3;
            Tag tag = this.tags.get(i);
            if (StringUtils.equals((String)string, (String)tag.getName())) {
                bl2 = true;
                bl3 = true;
            } else {
                bl3 = false;
            }
            if (bl2 && (!bl3 || !bl)) continue;
            swiftTagListBlock.addTag(tag);
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock removeUntilFirst(String string, boolean bl) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        boolean bl2 = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (bl2) {
                swiftTagListBlock.addTag(tag);
                continue;
            }
            if (!StringUtils.equals((String)string, (String)tag.getName())) continue;
            bl2 = true;
            if (!bl) continue;
            swiftTagListBlock.addTag(tag);
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock removeSubBlock(String string) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            boolean bl3 = false;
            Tag tag = this.tags.get(i);
            if (StringUtils.equals((String)string, (String)tag.getValue())) {
                if (StringUtils.equals((String)"16R", (String)tag.getName())) {
                    bl = true;
                } else if (StringUtils.equals((String)"16S", (String)tag.getName())) {
                    bl2 = true;
                    bl3 = true;
                }
            }
            if (bl && (!bl || !bl2 || bl3)) continue;
            swiftTagListBlock.addTag(tag);
        }
        return swiftTagListBlock;
    }

    public boolean containsAnyOf(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (!this.containsTag(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAllOf(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (this.containsTag(string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SwiftTagListBlock filterByName(boolean bl, String ... stringArray) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        if (stringArray.length == 0) {
            if (!bl) {
                swiftTagListBlock.setTags(this.getTags());
            }
        } else {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag tag = this.tags.get(i);
                boolean bl2 = false;
                for (int j = 0; !bl2 && j < stringArray.length; ++j) {
                    if (!StringUtils.equals((String)tag.getName(), (String)stringArray[j])) continue;
                    bl2 = true;
                    stringArray = (String[])ArrayUtils.remove((Object[])stringArray, (int)j);
                }
                if (bl2 && bl) {
                    swiftTagListBlock.addTag(tag);
                }
                if (bl2 || bl) continue;
                swiftTagListBlock.addTag(tag);
            }
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock filterByNameOrdered(String ... stringArray) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        for (Tag tag : this.getTags()) {
            boolean bl = false;
            for (int i = 0; !bl && i < stringArray.length; ++i) {
                if (!StringUtils.equals((String)tag.getName(), (String)stringArray[i])) continue;
                bl = true;
                stringArray = (String[])ArrayUtils.remove((Object[])stringArray, (int)i);
                swiftTagListBlock.addTag(tag);
            }
            if (bl) continue;
            break;
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock removeAfterFirst(String string, boolean bl) {
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag tag = this.tags.get(i);
                if (StringUtils.equals((String)string, (String)tag.getName())) {
                    if (bl) {
                        swiftTagListBlock.addTag(tag);
                    }
                    return swiftTagListBlock;
                }
                swiftTagListBlock.addTag(tag);
            }
        }
        return swiftTagListBlock;
    }

    public List<SwiftTagListBlock> getSubBlocksDelimitedWithOptionalTail(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (this.tags != null && !this.tags.isEmpty()) {
            ArrayList<SwiftTagListBlock> arrayList = new ArrayList<SwiftTagListBlock>();
            int n = 0;
            boolean bl = false;
            while (!bl) {
                int n2;
                int n3 = this.indexOfAnyFirstAfterIndex(n, stringArray);
                n = n2 = this.indexOfAnyFirstAfterIndex(n3 + 1, stringArray2);
                if (n3 == -1 || n2 == -1) {
                    bl = true;
                    continue;
                }
                if (n2 < n3) continue;
                SwiftTagListBlock swiftTagListBlock = this.sublist(n3, n2);
                if (stringArray3 != null && stringArray3.length > 0) {
                    boolean bl2 = false;
                    for (int i = n2 + 1; i < this.tags.size() && !bl2; ++i) {
                        boolean bl3 = false;
                        for (String string : stringArray3) {
                            Tag tag = this.tags.get(i);
                            if (!StringUtils.equals((String)tag.getName(), (String)string)) continue;
                            swiftTagListBlock.addTag(tag);
                            ++n;
                            bl3 = true;
                        }
                        if (bl3) continue;
                        bl2 = true;
                    }
                }
                arrayList.add(swiftTagListBlock);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public SwiftTagListBlock getSubBlockDelimitedWithOptionalTail(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (this.tags != null && !this.tags.isEmpty()) {
            int n = this.indexOfAnyFirst(stringArray);
            int n2 = this.indexOfAnyFirstAfterIndex(n + 1, stringArray2);
            if (n != -1 && n2 != -1 && n2 >= n) {
                SwiftTagListBlock swiftTagListBlock = this.sublist(n, n2);
                if (stringArray3 == null || stringArray3.length == 0) {
                    return swiftTagListBlock;
                }
                boolean bl = false;
                for (int i = n2 + 1; i < this.tags.size() && !bl; ++i) {
                    boolean bl2 = false;
                    for (String string : stringArray3) {
                        if (!StringUtils.equals((String)this.tags.get(i).getName(), (String)string)) continue;
                        swiftTagListBlock.addTag(this.tags.get(i));
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = true;
                }
                return swiftTagListBlock;
            }
        }
        return null;
    }

    public SwiftTagListBlock sublist(Integer n, Integer n2) {
        if (this.tags == null || this.tags.isEmpty()) {
            throw new IllegalStateException("No tags in this list");
        }
        if (n != null && n < 0 || n2 != null && n2 + 1 > this.tags.size() || n != null && n2 != null && n > n2) {
            throw new IllegalArgumentException("start: " + n + ", end: " + n2 + ", size=" + this.tags.size());
        }
        SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
        int n3 = n == null ? 0 : n;
        int n4 = n2 == null ? this.tags.size() - 1 : n2;
        for (int i = n3; i <= n4; ++i) {
            swiftTagListBlock.addTag(this.tags.get(i));
        }
        return swiftTagListBlock;
    }

    public SwiftTagListBlock getOptionalList(String[][] stringArray) {
        return this.getOptionalList(stringArray, 0);
    }

    public SwiftTagListBlock getOptionalList(String[][] stringArray, int n) {
        if (this.tags != null && !this.tags.isEmpty()) {
            SwiftTagListBlock swiftTagListBlock = new SwiftTagListBlock();
            boolean bl = false;
            int n2 = n;
            int n3 = 0;
            do {
                Tag tag;
                int n4;
                if ((n4 = this.findTagInRowSince(tag = this.tags.get(n2++), n3, stringArray)) >= 0) {
                    n3 = n4 + 1;
                    swiftTagListBlock.addTag(tag);
                    continue;
                }
                bl = true;
            } while (!bl);
            return swiftTagListBlock;
        }
        return null;
    }

    private int findTagInRowSince(Tag tag, int n, String[][] stringArray) {
        for (int i = n; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = stringArray2[j];
                if (!StringUtils.equals((String)tag.getName(), (String)string)) continue;
                return i;
            }
        }
        return -1;
    }

    public List<SwiftTagListBlock> getOptionalLists(String[][] stringArray) {
        ArrayList<SwiftTagListBlock> arrayList = new ArrayList<SwiftTagListBlock>();
        if (this.tags != null && !this.tags.isEmpty()) {
            boolean bl = false;
            int n = 0;
            while (!bl) {
                SwiftTagListBlock swiftTagListBlock;
                if ((n += (swiftTagListBlock = this.getOptionalList(stringArray, n)).size()) > this.tags.size() || swiftTagListBlock.isEmpty()) {
                    bl = true;
                }
                if (swiftTagListBlock.isEmpty()) continue;
                arrayList.add(swiftTagListBlock);
            }
        }
        return arrayList;
    }

    public List<String> tagNamesList() {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Tag tag : this.tags) {
            arrayList.add(tag.getName());
        }
        return arrayList;
    }

    public int countTagsStarsWith(String string, String string2) {
        int n = 0;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (Tag tag : this.tags) {
                if (!StringUtils.equals((String)string, (String)tag.getName()) || !tag.startsWith(string2)) continue;
                ++n;
            }
        }
        return n;
    }

    public SwiftTagListBlock removeAfterFirstStartsWith(String string, String string2) {
        if (this.tags == null || this.tags.size() == 0) {
            return new SwiftTagListBlock();
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        boolean bl = false;
        for (int i = 0; i < this.tags.size() && !bl; ++i) {
            Tag tag = this.tags.get(i);
            if (StringUtils.equals((String)tag.getName(), (String)string) && tag.startsWith(string2)) {
                bl = true;
                continue;
            }
            arrayList.add(tag);
        }
        return new SwiftTagListBlock(arrayList);
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ \n");
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag tag = this.tags.get(i);
                stringBuilder.append("{ \"").append(tag.getName()).append("\" : \"").append(this.escapeJson(tag.getValue())).append("\" }");
                if (i + 1 < this.tags.size()) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String escapeJson(String string) {
        String string2 = StringUtils.replace((String)string, (String)"\n", (String)"\\n");
        string2 = StringUtils.replace((String)string2, (String)"\"", (String)"\\\"");
        string2 = StringUtils.remove((String)string2, (String)"\r");
        return string2;
    }

    public SwiftTagListBlock append(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock != null && !swiftTagListBlock.isEmpty()) {
            this.tags.addAll(swiftTagListBlock.getTags());
        }
        return this;
    }

    @Override
    public Iterator<Tag> iterator() {
        if (this.tags == null) {
            Collections.emptyList().iterator();
        }
        return this.tags.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyItr
    implements Iterator<Tag> {
        private EmptyItr() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Tag next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove on an empty iterator");
        }
    }
}

