/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.SequenceNode;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(SwiftMessage.class.getName());
    private static final int JSON_VERSION = 1;
    private SwiftBlock1 block1;
    private SwiftBlock2 block2;
    private SwiftBlock3 block3;
    private SwiftBlock4 block4;
    private SwiftBlock5 block5;
    private SequenceNode parsedSequences;
    protected List<SwiftBlockUser> userBlocks;
    protected UnparsedTextList unparsedTexts = null;
    protected Long id;
    private boolean initBlocks = false;

    public SwiftMessage() {
        this.initBlocks();
    }

    public SwiftMessage(boolean bl) {
        this.initBlocks = bl;
        if (bl) {
            this.initBlocks();
        }
    }

    public SwiftMessage(boolean bl, UnparsedTextList unparsedTextList) {
        this(bl);
        this.unparsedTexts = unparsedTextList;
    }

    public SwiftMessage(UnparsedTextList unparsedTextList) {
        this();
        this.unparsedTexts = unparsedTextList;
    }

    private void initBlocks() {
        if (this.initBlocks) {
            this.addBlock(new SwiftBlock1());
            this.addBlock(new SwiftBlock2Input());
            this.addBlock(new SwiftBlock3());
            this.addBlock(new SwiftBlock4());
            this.addBlock(new SwiftBlock5());
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
    }

    public SwiftBlock getBlock(int n) {
        Validate.isTrue((1 <= n && n <= 5 ? 1 : 0) != 0, (String)("block index must be 1-5 (was " + n + ")"));
        switch (n) {
            case 1: {
                return this.block1;
            }
            case 2: {
                return this.block2;
            }
            case 3: {
                return this.block3;
            }
            case 4: {
                return this.block4;
            }
            case 5: {
                return this.block5;
            }
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void addBlock(SwiftBlock swiftBlock) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add block " + swiftBlock);
        }
        Validate.notNull((Object)swiftBlock);
        if (swiftBlock instanceof SwiftBlockUser) {
            this.addUserBlock((SwiftBlockUser)swiftBlock);
        } else {
            Validate.notNull((Object)swiftBlock.getNumber(), (String)"SwiftBlock.getNumber() is null");
            int n = swiftBlock.getNumber();
            Validate.isTrue((n >= 1 && n <= 5 ? 1 : 0) != 0, (String)"SwiftBlock.getNumber int did not return an int between 1-5");
            switch (n) {
                case 1: {
                    this.setBlock1((SwiftBlock1)swiftBlock);
                    break;
                }
                case 2: {
                    this.setBlock2((SwiftBlock2)swiftBlock);
                    break;
                }
                case 3: {
                    this.setBlock3((SwiftBlock3)swiftBlock);
                    break;
                }
                case 4: {
                    this.setBlock4((SwiftBlock4)swiftBlock);
                    break;
                }
                case 5: {
                    this.setBlock5((SwiftBlock5)swiftBlock);
                }
            }
        }
    }

    public boolean isMT(String string) {
        Validate.notNull((Object)string);
        Validate.isTrue((string.length() == 3 ? 1 : 0) != 0, (String)("The string must be exactly 3 chars size (type=" + string + ")"));
        return this.getType() != null && this.getType().equals(string);
    }

    public String getType() {
        SwiftBlock2 swiftBlock2 = this.getBlock2();
        if (swiftBlock2 == null) {
            return null;
        }
        if (swiftBlock2 instanceof SwiftBlock2Input) {
            return ((SwiftBlock2Input)swiftBlock2).getMessageType();
        }
        if (swiftBlock2 instanceof SwiftBlock2Output) {
            return ((SwiftBlock2Output)swiftBlock2).getMessageType();
        }
        return null;
    }

    public void visit(IMessageVisitor iMessageVisitor) {
        SwiftBlock5 swiftBlock5;
        SwiftBlock4 swiftBlock4;
        SwiftBlock3 swiftBlock3;
        SwiftBlock2 swiftBlock2;
        Validate.notNull((Object)iMessageVisitor);
        iMessageVisitor.startMessage(this);
        SwiftBlock1 swiftBlock1 = this.getBlock1();
        if (swiftBlock1 != null) {
            iMessageVisitor.startBlock1(swiftBlock1);
            iMessageVisitor.value(swiftBlock1, swiftBlock1.getValue());
            iMessageVisitor.endBlock1(swiftBlock1);
        }
        if ((swiftBlock2 = this.getBlock2()) != null) {
            iMessageVisitor.startBlock2(swiftBlock2);
            iMessageVisitor.value(swiftBlock2, swiftBlock2.getValue());
            iMessageVisitor.endBlock2(swiftBlock2);
        }
        if ((swiftBlock3 = this.getBlock3()) != null) {
            iMessageVisitor.startBlock3(swiftBlock3);
            this.visit(swiftBlock3, iMessageVisitor);
            iMessageVisitor.endBlock3(swiftBlock3);
        }
        if ((swiftBlock4 = this.getBlock4()) != null) {
            iMessageVisitor.startBlock4(swiftBlock4);
            this.visit(swiftBlock4, iMessageVisitor);
            iMessageVisitor.endBlock4(swiftBlock4);
        }
        if ((swiftBlock5 = this.getBlock5()) != null) {
            iMessageVisitor.startBlock5(swiftBlock5);
            this.visit(swiftBlock5, iMessageVisitor);
            iMessageVisitor.endBlock5(swiftBlock5);
        }
        if (this.userBlocks != null) {
            for (int i = 0; i < this.userBlocks.size(); ++i) {
                SwiftBlockUser swiftBlockUser = this.userBlocks.get(i);
                if (swiftBlockUser == null) continue;
                iMessageVisitor.startBlockUser(swiftBlockUser);
                this.visit(swiftBlockUser, iMessageVisitor);
                iMessageVisitor.endBlockUser(swiftBlockUser);
            }
        }
        iMessageVisitor.endMessage(this);
    }

    public void visit(SwiftBlock3 swiftBlock3, IMessageVisitor iMessageVisitor) {
        Validate.notNull((Object)swiftBlock3);
        Validate.notNull((Object)iMessageVisitor);
        Iterator<Tag> iterator = swiftBlock3.tagIterator();
        while (iterator.hasNext()) {
            iMessageVisitor.tag(swiftBlock3, iterator.next());
        }
    }

    public void visit(SwiftBlock4 swiftBlock4, IMessageVisitor iMessageVisitor) {
        Validate.notNull((Object)swiftBlock4);
        Validate.notNull((Object)iMessageVisitor);
        Iterator<Tag> iterator = swiftBlock4.tagIterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            iMessageVisitor.tag(swiftBlock4, tag);
        }
    }

    public void visit(SwiftBlock5 swiftBlock5, IMessageVisitor iMessageVisitor) {
        Validate.notNull((Object)swiftBlock5);
        Validate.notNull((Object)iMessageVisitor);
        Iterator<Tag> iterator = swiftBlock5.tagIterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            iMessageVisitor.tag(swiftBlock5, tag);
        }
    }

    public void visit(SwiftBlockUser swiftBlockUser, IMessageVisitor iMessageVisitor) {
        Validate.notNull((Object)swiftBlockUser);
        Validate.notNull((Object)iMessageVisitor);
        Iterator<Tag> iterator = swiftBlockUser.tagIterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            iMessageVisitor.tag(swiftBlockUser, tag);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public int getBlockCount() {
        return this.getBlockCount(Boolean.TRUE);
    }

    public int getBlockCount(Boolean bl) {
        int n = 0;
        if (this.block1 != null && !this.getBlock1().isEmpty()) {
            ++n;
        }
        if (this.block2 != null && !this.getBlock2().isEmpty()) {
            ++n;
        }
        if (this.block3 != null && !this.getBlock3().isEmpty()) {
            ++n;
        }
        if (this.block4 != null && !this.getBlock4().isEmpty()) {
            ++n;
        }
        if (this.block5 != null && !this.getBlock5().isEmpty()) {
            ++n;
        }
        if (bl.booleanValue() && this.userBlocks != null) {
            n += this.userBlocks.size();
        }
        return n;
    }

    public SwiftBlock1 getBlock1() {
        return this.block1;
    }

    public void setBlock1(SwiftBlock1 swiftBlock1) {
        this.block1 = swiftBlock1;
    }

    public SwiftBlock2 getBlock2() {
        return this.block2;
    }

    public void setBlock2(SwiftBlock2 swiftBlock2) {
        this.block2 = swiftBlock2;
    }

    public SwiftBlock3 getBlock3() {
        return this.block3;
    }

    public void setBlock3(SwiftBlock3 swiftBlock3) {
        this.block3 = swiftBlock3;
    }

    public SwiftBlock4 getBlock4() {
        return this.block4;
    }

    public void setBlock4(SwiftBlock4 swiftBlock4) {
        this.block4 = swiftBlock4;
    }

    public SwiftBlock5 getBlock5() {
        return this.block5;
    }

    public void setBlock5(SwiftBlock5 swiftBlock5) {
        this.block5 = swiftBlock5;
    }

    public int getUserBlockPosition(String string) {
        if (StringUtils.isBlank((String)string) || this.userBlocks == null) {
            return -1;
        }
        for (int i = 0; i < this.userBlocks.size(); ++i) {
            SwiftBlockUser swiftBlockUser = this.userBlocks.get(i);
            if (swiftBlockUser == null || !StringUtils.equals((String)swiftBlockUser.getName(), (String)string)) continue;
            return i;
        }
        return -1;
    }

    public List<SwiftBlockUser> getUserBlocks() {
        return this.userBlocks;
    }

    protected void setUserBlocks(List<SwiftBlockUser> list) {
        Validate.notNull(list, (String)"parameter 'userBlocks' cannot be null");
        Validate.allElementsOfType(list, SwiftBlockUser.class, (String)"parameter 'userBlocks' may only have SwiftBlockUser elements");
        this.userBlocks = list;
    }

    public SwiftBlockUser getUserBlock(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        int n = this.getUserBlockPosition(string);
        if (n != -1) {
            return this.userBlocks.get(n);
        }
        return null;
    }

    public SwiftBlockUser getUserBlock(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        return this.getUserBlock(n.toString());
    }

    public void addUserBlock(SwiftBlockUser swiftBlockUser) {
        int n;
        Validate.notNull((Object)swiftBlockUser);
        Validate.isTrue((boolean)swiftBlockUser.isValidName(), (String)("Invalid name for User Defined Blocks (" + swiftBlockUser.getName() + ")"));
        if (this.userBlocks == null) {
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
        if ((n = this.getUserBlockPosition(swiftBlockUser.getName())) != -1) {
            this.userBlocks.add(n, swiftBlockUser);
        } else {
            this.userBlocks.add(swiftBlockUser);
        }
    }

    public void removeUserBlock(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(n), (String)("Invalid name for User Defined Blocks (" + n.toString() + ")"));
        this.removeUserBlock(n.toString());
    }

    public void removeUserBlock(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(string), (String)("Invalid name for User Defined Blocks (" + string + ")"));
        int n = this.getUserBlockPosition(string);
        if (n != -1) {
            this.userBlocks.remove(n);
        }
    }

    public void clear() {
        this.block1 = null;
        this.block2 = null;
        this.block3 = null;
        this.block4 = null;
        this.block5 = null;
        this.userBlocks = null;
    }

    public Boolean isFragment() {
        SwiftBlock4 swiftBlock4 = this.getBlock4();
        if (swiftBlock4 != null) {
            String string = swiftBlock4.getTagValue("202");
            String string2 = swiftBlock4.getTagValue("203");
            return string != null && string2 != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLastFragment() {
        if (!this.isFragment().booleanValue()) {
            return Boolean.FALSE;
        }
        try {
            Integer n = this.fragmentCount();
            Integer n2 = this.fragmentNumber();
            return n.intValue() == n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Boolean.FALSE;
        }
    }

    public Integer fragmentCount() {
        Integer n;
        if (!this.isFragment().booleanValue()) {
            return new Integer(0);
        }
        SwiftBlock4 swiftBlock4 = this.getBlock4();
        String string = swiftBlock4.getTagValue("203");
        try {
            n = new Integer(Integer.parseInt(string, 10));
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return n;
    }

    public Integer fragmentNumber() {
        Integer n;
        if (!this.isFragment().booleanValue()) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        SwiftBlock4 swiftBlock4 = this.getBlock4();
        String string = swiftBlock4.getTagValue("202");
        try {
            n = new Integer(Integer.parseInt(string, 10));
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return n;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList unparsedTextList) {
        this.unparsedTexts = unparsedTextList;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(n);
    }

    public String unparsedTextGetText(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(n);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(n);
    }

    public void unparsedTextAddText(String string) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(string);
    }

    public void unparsedTextAddText(SwiftMessage swiftMessage) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(swiftMessage);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.block1 == null ? 0 : this.block1.hashCode());
        n = 31 * n + (this.block2 == null ? 0 : this.block2.hashCode());
        n = 31 * n + (this.block3 == null ? 0 : this.block3.hashCode());
        n = 31 * n + (this.block4 == null ? 0 : this.block4.hashCode());
        n = 31 * n + (this.block5 == null ? 0 : this.block5.hashCode());
        n = 31 * n + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        n = 31 * n + (this.userBlocks == null ? 0 : ((Object)this.userBlocks).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftMessage swiftMessage = (SwiftMessage)object;
        if (this.block1 == null ? swiftMessage.block1 != null : !this.block1.equals(swiftMessage.block1)) {
            return false;
        }
        if (this.block2 == null ? swiftMessage.block2 != null : !this.block2.equals(swiftMessage.block2)) {
            return false;
        }
        if (this.block3 == null ? swiftMessage.block3 != null : !this.block3.equals(swiftMessage.block3)) {
            return false;
        }
        if (this.block4 == null ? swiftMessage.block4 != null : !this.block4.equals(swiftMessage.block4)) {
            return false;
        }
        if (this.block5 == null ? swiftMessage.block5 != null : !this.block5.equals(swiftMessage.block5)) {
            return false;
        }
        if (this.unparsedTexts == null ? swiftMessage.unparsedTexts != null : !this.unparsedTexts.equals(swiftMessage.unparsedTexts)) {
            return false;
        }
        return !(this.userBlocks == null ? swiftMessage.userBlocks != null : !((Object)this.userBlocks).equals(swiftMessage.userBlocks));
    }

    public boolean isCOV() {
        if (this.block3 != null) {
            return this.block3.containsTag(new Tag("119", "COV"));
        }
        return false;
    }

    public boolean isSTP() {
        if (this.block3 != null) {
            return this.block3.containsTag(new Tag("119", "STP"));
        }
        return false;
    }

    public String getSender() {
        try {
            if (this.getDirection() == MessageIOType.incoming) {
                return ((SwiftBlock2Output)this.getBlock2()).getMIRLogicalTerminal();
            }
            if (this.getDirection() == MessageIOType.outgoing) {
                return this.getBlock1().getLogicalTerminal();
            }
            return null;
        }
        catch (Exception exception) {
            log.severe("Exception ocurred while retrieving sender's BIC from message data: " + exception);
            return null;
        }
    }

    public String getReceiver() {
        try {
            if (this.getDirection() == MessageIOType.incoming) {
                return this.getBlock1().getLogicalTerminal();
            }
            if (this.getDirection() == MessageIOType.outgoing) {
                return ((SwiftBlock2Input)this.getBlock2()).getReceiverAddress();
            }
            return null;
        }
        catch (Exception exception) {
            log.severe("Exception ocurred while retrieving receiver's BIC from message data: " + exception);
            return null;
        }
    }

    public List<Field> fields(String ... stringArray) {
        Validate.notNull((Object)stringArray, (String)"names is null");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (String string : stringArray) {
            Tag[] tagArray = this.getBlock4().getTagsByName(string);
            if (tagArray == null || tagArray.length <= 0) continue;
            for (Tag tag : tagArray) {
                arrayList.add(tag.getField());
            }
        }
        return arrayList;
    }

    public void removeEmptyBlocks() {
        if (this.block1 != null && this.getBlock1().isEmpty()) {
            this.block1 = null;
        }
        if (this.block2 != null && this.getBlock2().isEmpty()) {
            this.block2 = null;
        }
        if (this.block3 != null && this.getBlock3().isEmpty()) {
            this.block3 = null;
        }
        if (this.block4 != null && this.getBlock4().isEmpty()) {
            this.block4 = null;
        }
        if (this.block5 != null && this.getBlock5().isEmpty()) {
            this.block5 = null;
        }
    }

    public int getTypeInt() {
        try {
            return Integer.valueOf(this.getType());
        }
        catch (NumberFormatException numberFormatException) {
            log.log(Level.WARNING, "Erorr converting type to int " + this.getType(), numberFormatException);
            return -1;
        }
    }

    public MessageIOType getDirection() {
        try {
            if (this.getBlock2().isOutput()) {
                return MessageIOType.incoming;
            }
            if (this.getBlock2().isInput()) {
                return MessageIOType.outgoing;
            }
            return null;
        }
        catch (Exception exception) {
            log.severe("Exception ocurred while determining direction from message data: " + exception);
            return null;
        }
    }

    public String getPDE() {
        return this.getBlock5() != null ? this.getBlock5().getTagValue("PDE") : null;
    }

    public String getPDM() {
        return this.getBlock5() != null ? this.getBlock5().getTagValue("PDM") : null;
    }

    public String getMIR() {
        if (this.getBlock2() != null && this.getBlock2().isOutput()) {
            SwiftBlock2Output swiftBlock2Output = (SwiftBlock2Output)this.getBlock2();
            return swiftBlock2Output.getMIR();
        }
        return null;
    }

    public String getMUR() {
        return this.getBlock3() != null ? this.getBlock3().getTagValue("108") : null;
    }

    public String getUUID() {
        return null;
    }

    public SequenceNode getParsedSequences() {
        return this.parsedSequences;
    }

    public void setParsedSequences(SequenceNode sequenceNode) {
        this.parsedSequences = sequenceNode;
    }

    public Field field(String string) {
        List<Field> list = this.fields(string);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public Boolean isLinked() {
        SwiftBlock4 swiftBlock4 = this.getBlock4();
        if (swiftBlock4 != null) {
            return !swiftBlock4.getSubBlock("LINK").isEmpty();
        }
        return null;
    }

    public List<SwiftTagListBlock> getLinkages() {
        SwiftBlock4 swiftBlock4 = this.getBlock4();
        if (swiftBlock4 != null) {
            return swiftBlock4.getSubBlocks("LINK");
        }
        return null;
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ \"version\" : ").append(1).append(",\n");
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm Z").format(Calendar.getInstance().getTime());
        stringBuilder.append(" \"timestamp\" : '").append(string).append("',\n");
        stringBuilder.append(" \"data\" : { \n");
        stringBuilder.append("\"block1\" : \n");
        if (this.block1 == null) {
            stringBuilder.append(" {}");
        } else {
            stringBuilder.append(this.block1.toJson());
        }
        stringBuilder.append(",\n");
        stringBuilder.append("\"block2\" : \n");
        if (this.block2 == null) {
            stringBuilder.append(" {}");
        } else {
            stringBuilder.append(this.block2.toJson());
        }
        stringBuilder.append(",\n");
        this.appendBlock("3", stringBuilder, this.block3);
        stringBuilder.append(',');
        this.appendBlock("4", stringBuilder, this.block4);
        stringBuilder.append(',');
        this.appendBlock("5", stringBuilder, this.block5);
        if (this.userBlocks != null && !this.userBlocks.isEmpty()) {
            Iterator<SwiftBlockUser> iterator = this.userBlocks.iterator();
            stringBuilder.append(',');
            stringBuilder.append("\"userblocks\" : [ \n");
            while (iterator.hasNext()) {
                SwiftBlockUser swiftBlockUser = iterator.next();
                stringBuilder.append("{ ");
                stringBuilder.append("\"name\" :  \"").append(swiftBlockUser.getName()).append("\",\n \"tags\" : ");
                stringBuilder.append(swiftBlockUser.toJson());
                stringBuilder.append("}\n");
            }
            stringBuilder.append("] \n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private void appendBlock(String string, StringBuilder stringBuilder, SwiftTagListBlock swiftTagListBlock) {
        stringBuilder.append("\"block" + string + "\" : \n");
        if (swiftTagListBlock == null) {
            stringBuilder.append("{ }");
        } else {
            stringBuilder.append(swiftTagListBlock.toJson());
        }
        stringBuilder.append("\n");
    }

    public AbstractMT toMT() {
        String string = this.getType();
        if (string == null) {
            log.warning("Can not create an instance of message with type not set:\n" + this.toString());
        } else {
            String string2 = String.valueOf(string.charAt(0));
            String string3 = "com.prowidesoftware.swift.model.mt.mt" + string2 + "xx.MT" + string;
            log.fine("About to create an instance of " + string3);
            try {
                Class<?> clazz = Class.forName(string3);
                return (AbstractMT)clazz.getConstructor(SwiftMessage.class).newInstance(this);
            }
            catch (Exception exception) {
                log.warning("Could not create instance of " + string3 + ": " + exception);
            }
        }
        return null;
    }
}

