/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftBlock2;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public class SwiftBlock2Output
extends SwiftBlock2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String senderInputTime;
    private String MIRDate;
    private String MIRLogicalTerminal;
    private String MIRSessionNumber;
    private String MIRSequenceNumber;
    private String receiverOutputDate;
    private String receiverOutputTime;

    public SwiftBlock2Output(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this.messageType = string;
        this.senderInputTime = string2;
        this.MIRDate = string3;
        this.MIRLogicalTerminal = string4;
        this.MIRSessionNumber = string5;
        this.MIRSequenceNumber = string6;
        this.receiverOutputDate = string7;
        this.receiverOutputTime = string8;
        this.messagePriority = string9;
    }

    public SwiftBlock2Output(String string) {
        this.setValue(string);
    }

    public SwiftBlock2Output() {
    }

    public void setSenderInputTime(String string) {
        this.senderInputTime = string;
    }

    public String getSenderInputTime() {
        return this.senderInputTime;
    }

    public void setMIRDate(String string) {
        this.MIRDate = string;
    }

    public String getMIRDate() {
        return this.MIRDate;
    }

    public void setMIRLogicalTerminal(String string) {
        this.MIRLogicalTerminal = string;
    }

    public void setMIRLogicalTerminal(LogicalTerminalAddress logicalTerminalAddress) {
        this.MIRLogicalTerminal = logicalTerminalAddress.getSenderLogicalTerminalAddress();
    }

    public void setSender(BIC bIC) {
        this.setMIRLogicalTerminal(new LogicalTerminalAddress(bIC.getBic11()));
    }

    public void setSender(String string) {
        this.setMIRLogicalTerminal(new LogicalTerminalAddress(string));
    }

    public String getMIRLogicalTerminal() {
        return this.MIRLogicalTerminal;
    }

    public BIC getSenderBIC() {
        return new BIC(this.MIRLogicalTerminal);
    }

    public void setMIRSessionNumber(String string) {
        this.MIRSessionNumber = string;
    }

    public String getMIRSessionNumber() {
        return this.MIRSessionNumber;
    }

    public void setMIRSequenceNumber(String string) {
        this.MIRSequenceNumber = string;
    }

    public String getMIRSequenceNumber() {
        return this.MIRSequenceNumber;
    }

    public String getMIR() {
        if (this.MIRDate == null && this.MIRLogicalTerminal == null && this.MIRSessionNumber == null && this.MIRSequenceNumber == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.MIRDate != null) {
            stringBuffer.append(this.MIRDate);
        }
        if (this.MIRLogicalTerminal != null) {
            stringBuffer.append(this.MIRLogicalTerminal);
        }
        if (this.MIRSessionNumber != null) {
            stringBuffer.append(this.MIRSessionNumber);
        }
        if (this.MIRSequenceNumber != null) {
            stringBuffer.append(this.MIRSequenceNumber);
        }
        return stringBuffer.toString();
    }

    public void setMIR(String string) {
        Validate.notNull((Object)string);
        Validate.isTrue((string.length() == 28 ? 1 : 0) != 0, (String)("expected a 28 characters string for MIR value and found a " + string.length() + " string:" + string));
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 6;
        this.setMIRDate(String.valueOf(stringBuffer.subSequence(n, n + n2)));
        n += n2;
        n2 = 12;
        this.setMIRLogicalTerminal(String.valueOf(stringBuffer.subSequence(n, n + n2)));
        n += n2;
        n2 = 4;
        this.setMIRSessionNumber(String.valueOf(stringBuffer.subSequence(n, n + n2)));
        n += n2;
        n2 = 6;
        this.setMIRSequenceNumber(String.valueOf(stringBuffer.subSequence(n, n + n2)));
        n += n2;
    }

    public void setReceiverOutputDate(String string) {
        this.receiverOutputDate = string;
    }

    public String getReceiverOutputDate() {
        return this.receiverOutputDate;
    }

    public void setReceiverOutputTime(String string) {
        this.receiverOutputTime = string;
    }

    public String getReceiverOutputTime() {
        return this.receiverOutputTime;
    }

    public boolean isEmpty() {
        return this.messageType == null && this.senderInputTime == null && this.getMIR() == null && this.receiverOutputDate == null && this.receiverOutputTime == null && this.messagePriority == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("O");
        if (this.messageType != null) {
            stringBuffer.append(this.messageType);
        }
        if (this.senderInputTime != null) {
            stringBuffer.append(this.senderInputTime);
        }
        if (this.getMIR() != null) {
            stringBuffer.append(this.getMIR());
        }
        if (this.receiverOutputDate != null) {
            stringBuffer.append(this.receiverOutputDate);
        }
        if (this.receiverOutputTime != null) {
            stringBuffer.append(this.receiverOutputTime);
        }
        if (this.messagePriority != null) {
            stringBuffer.append(this.messagePriority);
        }
        return stringBuffer.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String string) {
        int n = string.length();
        Validate.notNull((Object)string, (String)"value must not be null");
        Validate.isTrue((n == 46 || n == 48 || n == 47 || n == 49 ? 1 : 0) != 0, (String)("expected a string value of 46 and up to 49 chars and obtained a " + n + " chars string: '" + string + "'"));
        int n2 = 0;
        if (string.startsWith("2:O")) {
            n2 = 2;
        }
        if ((n -= n2) != 46 && n != 47) {
            throw new IllegalArgumentException("Value must match: O<mt><time><mir><date><time>[<pri>]");
        }
        if (Character.toUpperCase(string.charAt(n2)) != 'O') {
            throw new IllegalArgumentException("Value must match: O<mt><time><mir><date><time>[<pri>]");
        }
        int n3 = 3;
        this.setMessageType(this.getValuePart(string, ++n2, n3));
        n2 += n3;
        n3 = 4;
        this.setSenderInputTime(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 28;
        this.setMIR(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 6;
        this.setReceiverOutputDate(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 4;
        this.setReceiverOutputTime(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 1;
        this.setMessagePriority(this.getValuePart(string, n2, n3));
        n2 += n3;
    }

    public void setBlockValue(String string) {
        this.setValue(string);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.MIRDate == null ? 0 : this.MIRDate.hashCode());
        n = 31 * n + (this.MIRLogicalTerminal == null ? 0 : this.MIRLogicalTerminal.hashCode());
        n = 31 * n + (this.MIRSequenceNumber == null ? 0 : this.MIRSequenceNumber.hashCode());
        n = 31 * n + (this.MIRSessionNumber == null ? 0 : this.MIRSessionNumber.hashCode());
        n = 31 * n + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        n = 31 * n + (this.messageType == null ? 0 : this.messageType.hashCode());
        n = 31 * n + (this.receiverOutputDate == null ? 0 : this.receiverOutputDate.hashCode());
        n = 31 * n + (this.receiverOutputTime == null ? 0 : this.receiverOutputTime.hashCode());
        n = 31 * n + (this.senderInputTime == null ? 0 : this.senderInputTime.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlock2Output swiftBlock2Output = (SwiftBlock2Output)object;
        if (this.MIRDate == null ? swiftBlock2Output.MIRDate != null : !this.MIRDate.equals(swiftBlock2Output.MIRDate)) {
            return false;
        }
        if (this.MIRLogicalTerminal == null ? swiftBlock2Output.MIRLogicalTerminal != null : !this.MIRLogicalTerminal.equals(swiftBlock2Output.MIRLogicalTerminal)) {
            return false;
        }
        if (this.MIRSequenceNumber == null ? swiftBlock2Output.MIRSequenceNumber != null : !this.MIRSequenceNumber.equals(swiftBlock2Output.MIRSequenceNumber)) {
            return false;
        }
        if (this.MIRSessionNumber == null ? swiftBlock2Output.MIRSessionNumber != null : !this.MIRSessionNumber.equals(swiftBlock2Output.MIRSessionNumber)) {
            return false;
        }
        if (this.messagePriority == null ? swiftBlock2Output.messagePriority != null : !this.messagePriority.equals(swiftBlock2Output.messagePriority)) {
            return false;
        }
        if (this.messageType == null ? swiftBlock2Output.messageType != null : !this.messageType.equals(swiftBlock2Output.messageType)) {
            return false;
        }
        if (this.receiverOutputDate == null ? swiftBlock2Output.receiverOutputDate != null : !this.receiverOutputDate.equals(swiftBlock2Output.receiverOutputDate)) {
            return false;
        }
        if (this.receiverOutputTime == null ? swiftBlock2Output.receiverOutputTime != null : !this.receiverOutputTime.equals(swiftBlock2Output.receiverOutputTime)) {
            return false;
        }
        return !(this.senderInputTime == null ? swiftBlock2Output.senderInputTime != null : !this.senderInputTime.equals(swiftBlock2Output.senderInputTime));
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ \n");
        stringBuilder.append(" \"messageType\" : \"").append(this.messageType).append("\", \n");
        stringBuilder.append(" \"senderInputTime\" : \"").append(this.senderInputTime).append("\", \n");
        stringBuilder.append(" \"MIRDate\" : \"").append(this.MIRDate).append("\", \n");
        stringBuilder.append(" \"MIRLogicalTerminal\" : \"").append(this.MIRLogicalTerminal).append("\", \n");
        stringBuilder.append(" \"MIRSessionNumber\" : \"").append(this.MIRSessionNumber).append("\", \n");
        stringBuilder.append(" \"MIRSequenceNumber\" : \"").append(this.MIRSequenceNumber).append("\", \n");
        stringBuilder.append(" \"receiverOutputDate\" : \"").append(this.receiverOutputDate).append("\", \n");
        stringBuilder.append(" \"receiverOutputTime\" : \"").append(this.receiverOutputTime).append("\", \n");
        stringBuilder.append(" \"messagePriority\" : \"").append(this.messagePriority).append("\" \n");
        stringBuilder.append("} ");
        return stringBuilder.toString();
    }
}

