/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftBlock2;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public class SwiftBlock2Input
extends SwiftBlock2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String receiverAddress;
    private String deliveryMonitoring;
    private String obsolescencePeriod;

    public SwiftBlock2Input(String string, String string2, String string3, String string4, String string5) {
        this.messageType = string;
        this.receiverAddress = string2;
        this.messagePriority = string3;
        this.deliveryMonitoring = string4;
        this.obsolescencePeriod = string5;
    }

    public SwiftBlock2Input(String string) {
        this.setValue(string);
    }

    public SwiftBlock2Input() {
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setReceiverAddress(String string) {
        this.receiverAddress = string;
    }

    public void setReceiverAddress(LogicalTerminalAddress logicalTerminalAddress) {
        this.receiverAddress = logicalTerminalAddress.getReceiverLogicalTerminalAddress();
    }

    public void setReceiver(BIC bIC) {
        this.setReceiverAddress(new LogicalTerminalAddress(bIC.getBic11()));
    }

    public void setReceiver(String string) {
        this.setReceiverAddress(new LogicalTerminalAddress(string));
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public BIC getReceiverBIC() {
        return new BIC(this.receiverAddress);
    }

    public void setMessagePriority(String string) {
        this.messagePriority = string;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public void setDeliveryMonitoring(String string) {
        this.deliveryMonitoring = string;
    }

    public String getDeliveryMonitoring() {
        return this.deliveryMonitoring;
    }

    public void setObsolescencePeriod(String string) {
        this.obsolescencePeriod = string;
    }

    public String getObsolescencePeriod() {
        return this.obsolescencePeriod;
    }

    public boolean isEmpty() {
        return this.messageType == null && this.receiverAddress == null && this.messagePriority == null && this.deliveryMonitoring == null && this.obsolescencePeriod == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("I");
        if (this.messageType != null) {
            stringBuffer.append(this.messageType);
        }
        if (this.receiverAddress != null) {
            stringBuffer.append(this.receiverAddress);
        }
        if (this.messagePriority != null) {
            stringBuffer.append(this.messagePriority);
        }
        if (this.deliveryMonitoring != null) {
            stringBuffer.append(this.deliveryMonitoring);
        }
        if (this.obsolescencePeriod != null) {
            stringBuffer.append(this.obsolescencePeriod);
        }
        return stringBuffer.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String string) {
        int n = string.length();
        Validate.notNull((Object)string, (String)"value must not be null");
        Validate.isTrue((n >= 16 && n <= 23 ? 1 : 0) != 0, (String)("expected a string value of 17 up to 23 chars and obtained a " + n + " chars string: '" + string + "'"));
        int n2 = 0;
        if (string.startsWith("2:I")) {
            n2 = 2;
        }
        if ((n -= n2) != 16 && n != 17 && n != 18 && n != 21) {
            throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
        }
        if (Character.toUpperCase(string.charAt(n2)) != 'I') {
            throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
        }
        int n3 = 3;
        this.setMessageType(this.getValuePart(string, ++n2, n3));
        n2 += n3;
        n3 = 12;
        this.setReceiverAddress(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 1;
        this.setMessagePriority(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 1;
        this.setDeliveryMonitoring(this.getValuePart(string, n2, n3));
        n2 += n3;
        n3 = 3;
        this.setObsolescencePeriod(this.getValuePart(string, n2, n3));
        n2 += n3;
    }

    public void setBlockValue(String string) {
        this.setValue(string);
    }

    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
        this.receiverAddress = null;
        this.deliveryMonitoring = null;
        this.obsolescencePeriod = null;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.deliveryMonitoring == null ? 0 : this.deliveryMonitoring.hashCode());
        n = 31 * n + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        n = 31 * n + (this.messageType == null ? 0 : this.messageType.hashCode());
        n = 31 * n + (this.obsolescencePeriod == null ? 0 : this.obsolescencePeriod.hashCode());
        n = 31 * n + (this.receiverAddress == null ? 0 : this.receiverAddress.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlock2Input swiftBlock2Input = (SwiftBlock2Input)object;
        if (this.deliveryMonitoring == null ? swiftBlock2Input.deliveryMonitoring != null : !this.deliveryMonitoring.equals(swiftBlock2Input.deliveryMonitoring)) {
            return false;
        }
        if (this.messagePriority == null ? swiftBlock2Input.messagePriority != null : !this.messagePriority.equals(swiftBlock2Input.messagePriority)) {
            return false;
        }
        if (this.messageType == null ? swiftBlock2Input.messageType != null : !this.messageType.equals(swiftBlock2Input.messageType)) {
            return false;
        }
        if (this.obsolescencePeriod == null ? swiftBlock2Input.obsolescencePeriod != null : !this.obsolescencePeriod.equals(swiftBlock2Input.obsolescencePeriod)) {
            return false;
        }
        return !(this.receiverAddress == null ? swiftBlock2Input.receiverAddress != null : !this.receiverAddress.equals(swiftBlock2Input.receiverAddress));
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ \n");
        stringBuilder.append(" \"messageType\" : \"").append(this.messageType).append("\", \n");
        stringBuilder.append(" \"receiverAddress\" : \"").append(this.receiverAddress).append("\", \n");
        stringBuilder.append(" \"messagePriority\" : \"").append(this.messagePriority).append("\", \n");
        stringBuilder.append(" \"deliveryMonitoring\" : \"").append(this.deliveryMonitoring).append("\", \n");
        stringBuilder.append(" \"obsolescencePeriod\" : \"").append(this.obsolescencePeriod).append("\" \n");
        stringBuilder.append("} ");
        return stringBuilder.toString();
    }
}

