/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SwiftBlock2
extends SwiftValueBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String messagePriority = "N";
    protected String messageType;

    protected void setBlockNumber(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((n == 2 ? 1 : 0) != 0, (String)"blockNumber must be 2");
    }

    protected void setBlockName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((string.compareTo("2") == 0 ? 1 : 0) != 0, (String)"blockName must be string '2'");
    }

    public Integer getNumber() {
        return new Integer(2);
    }

    public String getName() {
        return "2";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessagePriority(String string) {
        this.messagePriority = string;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public boolean isInput() {
        return this instanceof SwiftBlock2Input;
    }

    public boolean isOutput() {
        return this instanceof SwiftBlock2Output;
    }

    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        n = 31 * n + (this.messageType == null ? 0 : this.messageType.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlock2 swiftBlock2 = (SwiftBlock2)object;
        if (this.messagePriority == null ? swiftBlock2.messagePriority != null : !this.messagePriority.equals(swiftBlock2.messagePriority)) {
            return false;
        }
        return !(this.messageType == null ? swiftBlock2.messageType != null : !this.messageType.equals(swiftBlock2.messageType));
    }

    public String toJson() {
        return null;
    }
}

