/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MxNode {
    public static final transient String PATH_SEPARATOR = "/";
    private MxNode parent = null;
    private List<MxNode> children = new ArrayList<MxNode>();
    private String value = null;
    private String localName;

    public MxNode() {
    }

    public MxNode(MxNode mxNode, String string) {
        this();
        this.localName = string;
        if (mxNode != null) {
            this.bindParent(mxNode);
        }
    }

    private void bindParent(MxNode mxNode) {
        this.parent = mxNode;
        mxNode.addChild(this);
    }

    private void addChild(MxNode mxNode) {
        this.children.add(mxNode);
    }

    public String singlePathValue(String string) {
        MxNode mxNode = this.findFirst(string);
        if (mxNode != null) {
            return mxNode.getValue();
        }
        return null;
    }

    private MxNode findFirst(String string) {
        MxNode mxNode = this.getRoot();
        String[] stringArray = StringUtils.split((String)string, (String)PATH_SEPARATOR);
        return MxNode.findFirst(0, stringArray, this.getRoot());
    }

    private static MxNode findFirst(int n, String[] stringArray, MxNode mxNode) {
        if (StringUtils.equals((String)mxNode.localName, (String)stringArray[n])) {
            if (n + 1 == stringArray.length) {
                return mxNode;
            }
            if (n + 1 < stringArray.length) {
                for (MxNode mxNode2 : mxNode.children) {
                    MxNode mxNode3;
                    if ((mxNode3 = MxNode.findFirst(++n, stringArray, mxNode2)) == null) continue;
                    return mxNode3;
                }
            }
        }
        return null;
    }

    public MxNode getRoot() {
        return MxNode._getRoot(this);
    }

    private static MxNode _getRoot(MxNode mxNode) {
        if (mxNode == null) {
            return null;
        }
        return mxNode.parent == null ? mxNode : MxNode._getRoot(mxNode.parent);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return "MxNode{localName='" + this.localName + '\'' + '}';
    }

    public void print() {
        PrintStream printStream = System.out;
        try {
            this._print(0, this.getRoot(), printStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void _print(int n, MxNode mxNode, PrintStream printStream) throws IOException {
        for (int i = 0; i < n; ++i) {
            printStream.write("   ".getBytes());
        }
        printStream.write((mxNode.localName + "\n").getBytes());
        ++n;
        for (MxNode mxNode2 : mxNode.children) {
            this._print(n, mxNode2, printStream);
        }
    }

    public MxNode getParent() {
        return this.parent;
    }
}

