/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class MtSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MtSwiftMessage.class.getName());
    private SwiftMessage modelMessage;
    private String pde;
    private String pdm;
    private String mir;
    private String mur;
    private String uuid;

    public MtSwiftMessage() {
    }

    public MtSwiftMessage(String string) {
        this.updateFromFIN(string);
    }

    public MtSwiftMessage(SwiftMessage swiftMessage) {
        this.updateFromModel(swiftMessage);
    }

    public void updateFromFIN(String string) {
        Validate.notNull((Object)string, (String)"the raw message parameter cannot be null");
        this.setMessage(string);
        this.updateFromFIN();
    }

    public void updateFromFIN() {
        Validate.notNull((Object)this.getMessage(), (String)"the raw message attribute cannot be null");
        SwiftMessage swiftMessage = new ConversionService().getMessageFromFIN(this.getMessage());
        Validate.notNull((Object)swiftMessage, (String)"the raw message parameter could not be parsed into a SwiftMessage");
        this.modelMessage = swiftMessage;
        this.updateAttributesFromModel();
    }

    public void updateFromModel(SwiftMessage swiftMessage) {
        Validate.notNull((Object)swiftMessage, (String)"the model message cannot be null");
        this.setModelMessage(swiftMessage);
        this.updateFromModel();
    }

    public void updateFromModel() {
        Validate.notNull((Object)this.modelMessage, (String)"the model message cannot be null");
        String string = new ConversionService().getFIN(this.modelMessage);
        Validate.notNull((Object)string, (String)"the raw message could not be created from the SwiftMessage parameter");
        this.setMessage(string);
        this.updateAttributesFromModel();
    }

    private void updateAttributesFromModel() {
        this.setIdentifier(this.getModelMessage().getType());
        this.setSender(this.getModelMessage().getSender());
        this.setReceiver(this.getModelMessage().getReceiver());
        this.setDirection(this.getModelMessage().getDirection());
        this.setChecksum(SwiftMessageUtils.calculateChecksum(this.getModelMessage()));
        this.setPde(this.getModelMessage().getPDE());
        this.setPdm(this.getModelMessage().getPDM());
        this.setMir(this.getModelMessage().getMIR());
        this.setMur(this.getModelMessage().getMUR());
        this.setUuid(this.getModelMessage().getUUID());
        this.setLastModified(Calendar.getInstance());
    }

    public SwiftMessage getModelMessage() {
        if (this.modelMessage == null && this.getMessage() != null) {
            ConversionService conversionService = new ConversionService();
            this.modelMessage = conversionService.getMessageFromFIN(this.getMessage());
        }
        return this.modelMessage;
    }

    public void setModelMessage(SwiftMessage swiftMessage) {
        this.modelMessage = swiftMessage;
    }

    public String getMessageType() {
        return this.getIdentifier();
    }

    public Integer getMessageTypeInt() {
        if (this.getIdentifier() != null && StringUtils.isNumeric((String)this.getIdentifier())) {
            return Integer.parseInt(this.getMessageType());
        }
        return null;
    }

    public String getMessageName() {
        String string = this.getMessageName();
        if (string != null) {
            return string;
        }
        return this.getMessageType();
    }

    public boolean isType(Integer ... integerArray) {
        for (Integer n : integerArray) {
            if (!this.isType((int)n)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(int n) {
        String string = n < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n);
        return StringUtils.equals((String)string, (String)this.getMessageType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MtSwiftMessage id=").append(this.getId()).append(" parsedMessage=").append(this.getMessage());
        return stringBuilder.toString();
    }

    public String getPde() {
        return this.pde;
    }

    public void setPde(String string) {
        this.pde = string;
    }

    public String getPdm() {
        return this.pdm;
    }

    public void setPdm(String string) {
        this.pde = string;
    }

    public String getMir() {
        return this.mir;
    }

    public void setMir(String string) {
        this.mir = string;
    }

    public String getMur() {
        return this.mur;
    }

    public void setMur(String string) {
        this.mur = string;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mir == null ? 0 : this.mir.hashCode());
        n = 31 * n + (this.mur == null ? 0 : this.mur.hashCode());
        n = 31 * n + (this.pde == null ? 0 : this.pde.hashCode());
        n = 31 * n + (this.pdm == null ? 0 : this.pdm.hashCode());
        n = 31 * n + (this.uuid == null ? 0 : this.uuid.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MtSwiftMessage mtSwiftMessage = (MtSwiftMessage)object;
        if (this.mir == null ? mtSwiftMessage.mir != null : !this.mir.equals(mtSwiftMessage.mir)) {
            return false;
        }
        if (this.mur == null ? mtSwiftMessage.mur != null : !this.mur.equals(mtSwiftMessage.mur)) {
            return false;
        }
        if (this.pde == null ? mtSwiftMessage.pde != null : !this.pde.equals(mtSwiftMessage.pde)) {
            return false;
        }
        if (this.pdm == null ? mtSwiftMessage.pdm != null : !this.pdm.equals(mtSwiftMessage.pdm)) {
            return false;
        }
        return !(this.uuid == null ? mtSwiftMessage.uuid != null : !this.uuid.equals(mtSwiftMessage.uuid));
    }

    public MtSwiftMessage readFile(File file) throws IOException {
        MtSwiftMessage mtSwiftMessage = new MtSwiftMessage();
        mtSwiftMessage.setModelMessage(new SwiftParser(new FileInputStream(file)).message());
        mtSwiftMessage.setMessage(Lib.readFile(file));
        return mtSwiftMessage;
    }
}

