/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.ISOCountries;

public class BIC {
    public static final transient String TEST8 = "TESTUS00";
    public static final transient String TEST12 = "TESTAR00AXXX";
    private String invalidCause = null;
    private String bic8 = null;
    private String branch = null;
    private String subtype = null;

    public BIC(String string) {
        this.parse(string);
    }

    private void parse(String string) {
        if (string != null) {
            if (string.length() >= 8) {
                this.bic8 = string.substring(0, 8).toUpperCase();
            }
            if (string.length() == 11 || string.length() == 12) {
                this.branch = string.substring(string.length() - 3, string.length()).toUpperCase();
            }
        }
    }

    public BIC() {
    }

    public String getBic() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bic8 != null) {
            stringBuilder.append(this.bic8);
        }
        if (this.branch != null) {
            stringBuilder.append(this.branch);
        }
        return stringBuilder.toString();
    }

    public void setBic(String string) {
        this.parse(string);
    }

    public String getInvalidCause() {
        return this.invalidCause;
    }

    public boolean isValid() {
        if (this.bic8 == null) {
            this.invalidCause = "BIC is null";
            return false;
        }
        if (this.bic8.length() != 8 || this.branch != null && this.branch.length() != 3) {
            this.invalidCause = "BIC must be 8 or 11 chars";
            return false;
        }
        String string = this.bic8.substring(4, 6);
        if (!ISOCountries.getInstance().isValidCode(string.toUpperCase())) {
            this.invalidCause = "Invalid country code: " + string;
            return false;
        }
        return true;
    }

    String getBranch() {
        return this.branch;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String string) {
        this.subtype = string;
    }

    public boolean isTestAndTraining() {
        if (this.bic8 != null && this.bic8.length() >= 8) {
            return this.bic8.charAt(7) == '0';
        }
        return false;
    }

    public String getBic8() {
        return this.bic8;
    }

    public String getBic11() {
        String string;
        String string2 = string = this.branch != null ? this.branch : "XXX";
        if (this.bic8 != null) {
            return this.bic8 + string;
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bic8 == null ? 0 : this.bic8.hashCode());
        n = 31 * n + (this.branch == null ? 0 : this.branch.hashCode());
        n = 31 * n + (this.invalidCause == null ? 0 : this.invalidCause.hashCode());
        n = 31 * n + (this.subtype == null ? 0 : this.subtype.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BIC bIC = (BIC)object;
        if (this.bic8 == null ? bIC.bic8 != null : !this.bic8.equals(bIC.bic8)) {
            return false;
        }
        if (this.branch == null ? bIC.branch != null : !this.branch.equals(bIC.branch)) {
            return false;
        }
        if (this.invalidCause == null ? bIC.invalidCause != null : !this.invalidCause.equals(bIC.invalidCause)) {
            return false;
        }
        return !(this.subtype == null ? bIC.subtype != null : !this.subtype.equals(bIC.subtype));
    }
}

