/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.SwiftMessageNote;
import com.prowidesoftware.swift.model.SwiftMessageStatusInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSwiftMessage
implements Serializable {
    private static final transient Logger log = Logger.getLogger(AbstractSwiftMessage.class.getName());
    private static final long serialVersionUID = 1L;
    private Long id;
    private String message;
    private String identifier;
    private String sender;
    private String receiver;
    private MessageIOType direction;
    private String checksum;
    private Calendar lastModified = Calendar.getInstance();
    private Calendar creationDate = Calendar.getInstance();
    private List<SwiftMessageStatusInfo> statusTrail;
    private String status;
    private List<SwiftMessageNote> notes;
    private Map<String, String> properties = new HashMap<String, String>();
    private String filename;
    public static final transient String PROPERTY_NAME = "name";

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String string) {
        this.checksum = string;
    }

    @XmlTransient
    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar calendar) {
        this.lastModified = calendar;
    }

    @XmlTransient
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar calendar) {
        this.creationDate = calendar;
    }

    public List<SwiftMessageNote> getNotes() {
        return this.notes;
    }

    public void setNotes(List<SwiftMessageNote> list) {
        this.notes = list;
    }

    @XmlTransient
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> map) {
        this.properties = map;
    }

    public List<SwiftMessageStatusInfo> getStatusTrail() {
        return this.statusTrail;
    }

    public void setStatusTrail(List<SwiftMessageStatusInfo> list) {
        this.statusTrail = list;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String string) {
        this.receiver = string;
    }

    public MessageIOType getDirection() {
        return this.direction;
    }

    public void setDirection(MessageIOType messageIOType) {
        this.direction = messageIOType;
    }

    public String getMessageName() {
        Map<String, String> map = this.getProperties();
        if (map != null && map.containsKey(PROPERTY_NAME) && StringUtils.isNotBlank((String)map.get(PROPERTY_NAME))) {
            return map.get(PROPERTY_NAME);
        }
        return null;
    }

    public void addStatus(SwiftMessageStatusInfo swiftMessageStatusInfo) {
        if (swiftMessageStatusInfo != null) {
            if (this.statusTrail == null) {
                this.statusTrail = new ArrayList<SwiftMessageStatusInfo>();
            }
            this.statusTrail.add(swiftMessageStatusInfo);
            this.setStatus(swiftMessageStatusInfo.getName());
        }
    }

    public boolean isOutgoing() {
        return this.direction == MessageIOType.outgoing;
    }

    public boolean isInput() {
        return this.isOutgoing();
    }

    public Boolean isIncoming() {
        return this.direction == MessageIOType.incoming;
    }

    public Boolean isOutput() {
        return this.isIncoming();
    }

    public void setStatus(SwiftMessageStatusInfo swiftMessageStatusInfo) {
        this.addStatus(swiftMessageStatusInfo);
    }

    public boolean isStatus(String string) {
        return StringUtils.equals((String)string, (String)this.getStatus());
    }

    public boolean isStatus(Enum enum_) {
        if (enum_ != null) {
            return this.isStatus(enum_.name());
        }
        return false;
    }

    public SwiftMessageStatusInfo getStatusInfo() {
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public SwiftMessageStatusInfo getPreviousStatusInfo() {
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 2);
        }
        return null;
    }

    public boolean contains(Enum ... enumArray) {
        boolean bl = false;
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            for (SwiftMessageStatusInfo swiftMessageStatusInfo : this.getStatusTrail()) {
                for (Enum enum_ : enumArray) {
                    if (enum_ == null || !StringUtils.equals((String)swiftMessageStatusInfo.getName(), (String)enum_.name())) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean contains(String ... stringArray) {
        boolean bl = false;
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            for (SwiftMessageStatusInfo swiftMessageStatusInfo : this.getStatusTrail()) {
                for (String string : stringArray) {
                    if (string == null || !StringUtils.equals((String)swiftMessageStatusInfo.getName(), (String)string)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isStatus(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.isStatus(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isStatus(Enum ... enumArray) {
        for (Enum enum_ : enumArray) {
            if (enum_ == null || !this.isStatus(enum_.name())) continue;
            return true;
        }
        return false;
    }

    public String getLastData(String ... stringArray) {
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                String string = list.get(i).getData();
                if (string == null || stringArray != null && !ArrayUtils.contains((Object[])stringArray, (Object)list.get(i).getName())) continue;
                return string;
            }
        }
        return "";
    }

    public String getLastData() {
        return this.getLastData(null);
    }

    public SwiftMessageStatusInfo findStatusInfo(String string) {
        List<SwiftMessageStatusInfo> list = this.getStatusTrail();
        if (list != null && !list.isEmpty()) {
            for (SwiftMessageStatusInfo swiftMessageStatusInfo : list) {
                if (!StringUtils.equals((String)string, (String)swiftMessageStatusInfo.getName())) continue;
                return swiftMessageStatusInfo;
            }
        }
        return null;
    }

    public void addNote(SwiftMessageNote swiftMessageNote) {
        if (this.notes == null) {
            this.notes = new ArrayList<SwiftMessageNote>();
        }
        this.notes.add(swiftMessageNote);
    }

    public void sanityCheckProperties() {
        try {
            Map<String, String> map = this.getProperties();
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                if (string2 != null && string2.length() > 500) {
                    log.severe("Value for key=" + string + " too long, will be truncated. value=" + string2);
                    string2 = string2.substring(0, 500);
                    map.put(string, string2);
                }
                if (string.length() <= 200) continue;
                log.severe("Key too long: " + string + " will be truncated");
                map.remove(string);
                map.put(string.substring(0, 200), string2);
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error cheking properties", exception);
        }
    }

    public String getProperty(String string) {
        Map<String, String> map = this.getProperties();
        if (map != null && map.containsKey(string) && StringUtils.isNotBlank((String)map.get(string))) {
            return map.get(string);
        }
        return null;
    }

    public String getProperty(Enum enum_) {
        return this.getProperty(enum_.name());
    }

    public void setProperty(String string, String string2) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        if (StringUtils.isNotBlank((String)string2)) {
            this.getProperties().put(string, string2);
        }
    }

    public void setProperty(Enum enum_, String string) {
        this.setProperty(enum_.name(), string);
    }

    public boolean getPropertyBoolean(String string) {
        return StringUtils.equals((String)"true", (String)this.getProperty(string));
    }

    public boolean getPropertyBoolean(Enum enum_) {
        return this.getPropertyBoolean(enum_.name());
    }

    public String getPaddedId() {
        String string = this.id != null ? this.id.toString() : "0";
        return StringUtils.leftPad((String)string, (int)10, (String)"0");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.checksum == null ? 0 : this.checksum.hashCode());
        n = 31 * n + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        n = 31 * n + (this.direction == null ? 0 : this.direction.hashCode());
        n = 31 * n + (this.identifier == null ? 0 : this.identifier.hashCode());
        n = 31 * n + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        n = 31 * n + (this.message == null ? 0 : this.message.hashCode());
        n = 31 * n + (this.receiver == null ? 0 : this.receiver.hashCode());
        n = 31 * n + (this.sender == null ? 0 : this.sender.hashCode());
        n = 31 * n + (this.status == null ? 0 : this.status.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractSwiftMessage abstractSwiftMessage = (AbstractSwiftMessage)object;
        if (this.checksum == null ? abstractSwiftMessage.checksum != null : !this.checksum.equals(abstractSwiftMessage.checksum)) {
            return false;
        }
        if (this.creationDate == null ? abstractSwiftMessage.creationDate != null : !this.creationDate.equals(abstractSwiftMessage.creationDate)) {
            return false;
        }
        if (this.direction != abstractSwiftMessage.direction) {
            return false;
        }
        if (this.identifier == null ? abstractSwiftMessage.identifier != null : !this.identifier.equals(abstractSwiftMessage.identifier)) {
            return false;
        }
        if (this.lastModified == null ? abstractSwiftMessage.lastModified != null : !this.lastModified.equals(abstractSwiftMessage.lastModified)) {
            return false;
        }
        if (this.message == null ? abstractSwiftMessage.message != null : !this.message.equals(abstractSwiftMessage.message)) {
            return false;
        }
        if (this.receiver == null ? abstractSwiftMessage.receiver != null : !this.receiver.equals(abstractSwiftMessage.receiver)) {
            return false;
        }
        if (this.sender == null ? abstractSwiftMessage.sender != null : !this.sender.equals(abstractSwiftMessage.sender)) {
            return false;
        }
        return !(this.status == null ? abstractSwiftMessage.status != null : !this.status.equals(abstractSwiftMessage.status));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public abstract AbstractSwiftMessage readFile(File var1) throws IOException;
}

