/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import com.prowidesoftware.swift.WifeException;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(XMLWriterVisitor.class.getName());
    private static final String EOL = System.getProperties().getProperty("line.separator", "\n");
    private Writer writer;
    private boolean useField;

    public XMLWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    public XMLWriterVisitor(Writer writer, boolean bl) {
        this.writer = writer;
        this.useField = bl;
    }

    public void startMessage(SwiftMessage swiftMessage) {
        this.write("<message>");
    }

    public void endMessage(SwiftMessage swiftMessage) {
        if (swiftMessage.getUnparsedTextsSize() > 0) {
            this.write(swiftMessage.getUnparsedTexts(), 0);
        }
        this.write(EOL + "</message>");
    }

    public void startBlock1(SwiftBlock1 swiftBlock1) {
        this.write(EOL + "<block1>");
    }

    public void value(SwiftBlock1 swiftBlock1, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!swiftBlock1.isEmpty()) {
            this.appendElement(stringBuffer, "applicationId", swiftBlock1.getApplicationId());
            this.appendElement(stringBuffer, "serviceId", swiftBlock1.getServiceId());
            this.appendElement(stringBuffer, "logicalTerminal", swiftBlock1.getLogicalTerminal());
            if (swiftBlock1.getSessionNumber() != null) {
                this.appendElement(stringBuffer, "sessionNumber", swiftBlock1.getSessionNumber());
            }
            if (swiftBlock1.getSequenceNumber() != null) {
                this.appendElement(stringBuffer, "sequenceNumber", swiftBlock1.getSequenceNumber());
            }
            this.write(stringBuffer.toString());
        }
    }

    public void endBlock1(SwiftBlock1 swiftBlock1) {
        if (swiftBlock1.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock1.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block1>");
    }

    public void startBlock2(SwiftBlock2 swiftBlock2) {
        String string = "<block2>";
        if (!swiftBlock2.isEmpty()) {
            if (swiftBlock2 instanceof SwiftBlock2Input) {
                string = "<block2 type=\"input\">";
            }
            if (swiftBlock2 instanceof SwiftBlock2Output) {
                string = "<block2 type=\"output\">";
            }
        }
        this.write(EOL + string);
    }

    public void value(SwiftBlock2 swiftBlock2, String string) {
        SwiftBlock2 swiftBlock22;
        if (string == null || string.equals("")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (swiftBlock2 instanceof SwiftBlock2Input) {
            swiftBlock22 = (SwiftBlock2Input)swiftBlock2;
            this.appendElement(stringBuffer, "messageType", ((SwiftBlock2Input)swiftBlock22).getMessageType());
            this.appendElement(stringBuffer, "receiverAddress", ((SwiftBlock2Input)swiftBlock22).getReceiverAddress());
            if (((SwiftBlock2Input)swiftBlock22).getMessagePriority() != null) {
                this.appendElement(stringBuffer, "messagePriority", ((SwiftBlock2Input)swiftBlock22).getMessagePriority());
            }
            if (((SwiftBlock2Input)swiftBlock22).getDeliveryMonitoring() != null) {
                this.appendElement(stringBuffer, "deliveryMonitoring", ((SwiftBlock2Input)swiftBlock22).getDeliveryMonitoring());
            }
            if (((SwiftBlock2Input)swiftBlock22).getObsolescencePeriod() != null) {
                this.appendElement(stringBuffer, "obsolescencePeriod", ((SwiftBlock2Input)swiftBlock22).getObsolescencePeriod());
            }
        }
        if (swiftBlock2 instanceof SwiftBlock2Output) {
            swiftBlock22 = (SwiftBlock2Output)swiftBlock2;
            this.appendElement(stringBuffer, "messageType", swiftBlock22.getMessageType());
            this.appendElement(stringBuffer, "senderInputTime", ((SwiftBlock2Output)swiftBlock22).getSenderInputTime());
            this.appendElement(stringBuffer, "MIRDate", ((SwiftBlock2Output)swiftBlock22).getMIRDate());
            this.appendElement(stringBuffer, "MIRLogicalTerminal", ((SwiftBlock2Output)swiftBlock22).getMIRLogicalTerminal());
            this.appendElement(stringBuffer, "MIRSessionNumber", ((SwiftBlock2Output)swiftBlock22).getMIRSessionNumber());
            this.appendElement(stringBuffer, "MIRSequenceNumber", ((SwiftBlock2Output)swiftBlock22).getMIRSequenceNumber());
            this.appendElement(stringBuffer, "receiverOutputDate", ((SwiftBlock2Output)swiftBlock22).getReceiverOutputDate());
            this.appendElement(stringBuffer, "receiverOutputTime", ((SwiftBlock2Output)swiftBlock22).getReceiverOutputTime());
            if (swiftBlock22.getMessagePriority() != null) {
                this.appendElement(stringBuffer, "messagePriority", swiftBlock22.getMessagePriority());
            }
        }
        this.write(stringBuffer.toString());
    }

    public void endBlock2(SwiftBlock2 swiftBlock2) {
        if (swiftBlock2.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock2.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block2>");
    }

    public void startBlock3(SwiftBlock3 swiftBlock3) {
        this.write(EOL + "<block3>");
    }

    public void tag(SwiftBlock3 swiftBlock3, Tag tag) {
        this.appendTag(tag);
    }

    public void endBlock3(SwiftBlock3 swiftBlock3) {
        if (swiftBlock3.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock3.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block3>");
    }

    public void startBlock4(SwiftBlock4 swiftBlock4) {
        this.write(EOL + "<block4>");
    }

    public void tag(SwiftBlock4 swiftBlock4, Tag tag) {
        if (this.useField) {
            this.appendField(tag);
        } else {
            this.appendTag(tag);
        }
    }

    public void endBlock4(SwiftBlock4 swiftBlock4) {
        if (swiftBlock4.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock4.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block4>");
    }

    public void startBlock5(SwiftBlock5 swiftBlock5) {
        this.write(EOL + "<block5>");
    }

    public void tag(SwiftBlock5 swiftBlock5, Tag tag) {
        this.appendTag(tag);
    }

    public void endBlock5(SwiftBlock5 swiftBlock5) {
        if (swiftBlock5.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock5.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block5>");
    }

    public void startBlockUser(SwiftBlockUser swiftBlockUser) {
        this.write(EOL + "<block name=\"" + swiftBlockUser.getName() + "\">");
    }

    public void tag(SwiftBlockUser swiftBlockUser, Tag tag) {
        this.appendTag(tag);
    }

    public void endBlockUser(SwiftBlockUser swiftBlockUser) {
        if (swiftBlockUser.getUnparsedTextsSize() > 0) {
            this.write(swiftBlockUser.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block>");
    }

    public void tag(SwiftBlock swiftBlock, Tag tag) {
        if (swiftBlock == null) {
            return;
        }
        if (swiftBlock instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)swiftBlock, tag);
        }
    }

    private final void appendTag(Tag tag) {
        this.write(EOL + "\t<tag>");
        this.write(EOL + "\t\t<name>");
        if (tag.getName() != null) {
            this.write(tag.getName());
        }
        this.write("</name>");
        this.write(EOL + "\t\t<value>");
        if (tag.getValue() != null) {
            this.write(tag.getValue());
        }
        this.write("</value>");
        if (tag.getUnparsedTextsSize() > 0) {
            this.write(tag.getUnparsedTexts(), 2);
        }
        this.write(EOL + "\t</tag>");
    }

    private void appendField(Tag tag) {
        if (tag == null) {
            return;
        }
        Field field = tag.asField();
        if (field != null) {
            this.write(EOL + "\t<field>");
            this.write(EOL + "\t\t<name>");
            if (field.getName() != null) {
                this.write(field.getName());
            }
            this.write("</name>");
            List<String> list = field.getComponents();
            for (int i = 0; i < list.size(); ++i) {
                int n = i + 1;
                String string = list.get(i);
                if (string == null) continue;
                this.write(EOL + "\t\t<component number=\"" + n + "\">");
                this.write(string);
                this.write("</component>");
            }
            this.write(EOL + "\t</field>");
        }
    }

    private final void appendElement(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(EOL + "\t<").append(string).append('>').append(string2).append("</").append(string).append('>');
    }

    private void write(UnparsedTextList unparsedTextList, int n) {
        String string = "\t";
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "\t";
                break;
            }
            case 2: {
                string = "\t\t";
                break;
            }
            default: {
                string = "\t";
            }
        }
        if (unparsedTextList.size() > 0) {
            this.write(EOL + string + "<unparsedTexts>");
            for (int i = 0; i < unparsedTextList.size(); ++i) {
                this.write(EOL + string + "\t<text>");
                this.write(unparsedTextList.getText(new Integer(i)));
                this.write("</text>");
            }
            this.write(EOL + string + "</unparsedTexts>");
        }
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Caught exception in XMLWriterVisitor, method write", iOException);
            throw new WifeException(iOException);
        }
    }
}

