/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import com.prowidesoftware.swift.WifeException;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class FINWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(FINWriterVisitor.class.getName());
    public static final String SWIFT_EOL = "\r\n";
    private Writer writer;
    private Boolean block4asText = Boolean.TRUE;

    public FINWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    public void startMessage(SwiftMessage swiftMessage) {
        String string;
        Object object;
        SwiftBlock1 swiftBlock1;
        this.block4asText = Boolean.TRUE;
        SwiftBlock1 swiftBlock12 = swiftBlock1 = swiftMessage != null ? swiftMessage.getBlock1() : null;
        if (swiftBlock1 != null && StringUtils.isNotEmpty((String)swiftBlock1.getValue())) {
            object = swiftBlock1.getApplicationId() != null ? swiftBlock1.getApplicationId() : "";
            String string2 = string = swiftBlock1.getServiceId() != null ? swiftBlock1.getServiceId() : "";
            if (!((String)object).equals("F") || !string.equals("01")) {
                this.block4asText = Boolean.FALSE;
            }
        }
        Object object2 = object = swiftMessage != null ? swiftMessage.getBlock2() : null;
        if (object != null && StringUtils.isNotEmpty((String)((SwiftValueBlock)object).getValue())) {
            String string3 = string = ((SwiftBlock2)object).getMessageType() != null ? ((SwiftBlock2)object).getMessageType() : "";
            if (string.startsWith("0")) {
                this.block4asText = Boolean.FALSE;
            }
        }
    }

    public void endMessage(SwiftMessage swiftMessage) {
        if (swiftMessage.getUnparsedTextsSize() > 0) {
            this.write(swiftMessage.getUnparsedTexts());
        }
        this.block4asText = Boolean.TRUE;
    }

    public void startBlock1(SwiftBlock1 swiftBlock1) {
        this.write("{1:");
    }

    public void value(SwiftBlock1 swiftBlock1, String string) {
        if (string != null && !string.equals("")) {
            this.write(string);
        }
    }

    public void endBlock1(SwiftBlock1 swiftBlock1) {
        if (swiftBlock1.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock1.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock2(SwiftBlock2 swiftBlock2) {
        this.write("{2:");
    }

    public void value(SwiftBlock2 swiftBlock2, String string) {
        if (string != null && !string.equals("")) {
            this.write(string);
        }
    }

    public void endBlock2(SwiftBlock2 swiftBlock2) {
        if (swiftBlock2.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock2.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock3(SwiftBlock3 swiftBlock3) {
        this.write("{3:");
    }

    public void tag(SwiftBlock3 swiftBlock3, Tag tag) {
        this.appendBlockTag(tag);
    }

    public void endBlock3(SwiftBlock3 swiftBlock3) {
        if (swiftBlock3.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock3.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlock4(SwiftBlock4 swiftBlock4) {
        this.write("{4:" + (this.block4asText != false ? SWIFT_EOL : ""));
    }

    public void tag(SwiftBlock4 swiftBlock4, Tag tag) {
        if (this.block4asText.booleanValue()) {
            this.appendTextTag(tag);
        } else {
            this.appendBlockTag(tag);
        }
    }

    public void endBlock4(SwiftBlock4 swiftBlock4) {
        if (swiftBlock4.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock4.getUnparsedTexts());
        }
        this.write((this.block4asText != false ? "-" : "") + "}");
    }

    public void startBlock5(SwiftBlock5 swiftBlock5) {
        this.write("{5:");
    }

    public void tag(SwiftBlock5 swiftBlock5, Tag tag) {
        this.appendBlockTag(tag);
    }

    public void endBlock5(SwiftBlock5 swiftBlock5) {
        if (swiftBlock5.getUnparsedTextsSize() > 0) {
            this.write(swiftBlock5.getUnparsedTexts());
        }
        this.write("}");
    }

    public void startBlockUser(SwiftBlockUser swiftBlockUser) {
        this.write("{" + swiftBlockUser.getName() + ":");
    }

    public void tag(SwiftBlockUser swiftBlockUser, Tag tag) {
        this.appendBlockTag(tag);
    }

    public void endBlockUser(SwiftBlockUser swiftBlockUser) {
        if (swiftBlockUser.getUnparsedTextsSize() > 0) {
            this.write(swiftBlockUser.getUnparsedTexts());
        }
        this.write("}");
    }

    public void tag(SwiftBlock swiftBlock, Tag tag) {
        if (swiftBlock == null) {
            return;
        }
        if (swiftBlock instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)swiftBlock, tag);
        }
        if (swiftBlock instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)swiftBlock, tag);
        }
    }

    private final void appendBlockTag(Tag tag) {
        String string;
        String string2 = tag.getName() != null ? tag.getName() : "";
        String string3 = string = tag.getValue() != null ? tag.getValue() : "";
        if (string2.equals("") && string.equals("")) {
            return;
        }
        if (!string2.equals("")) {
            this.write("{" + string2 + ":" + string);
        } else {
            this.write("{" + string);
        }
        if (tag.getUnparsedTextsSize() > 0) {
            this.write(tag.getUnparsedTexts());
        }
        this.write("}");
    }

    private final void appendTextTag(Tag tag) {
        String string;
        String string2 = tag.getName() != null ? tag.getName() : "";
        String string3 = string = tag.getValue() != null ? tag.getValue() : "";
        if (!string2.equals("")) {
            this.write(":" + string2 + ":" + string + SWIFT_EOL);
        }
        if (tag.getUnparsedTextsSize() > 0) {
            this.write(tag.getUnparsedTexts());
        }
    }

    protected String getTagValue(Tag tag, int n) {
        String string = tag.getValue();
        if (tag.getName() == null && string.startsWith(n + ":") && string.length() > 2) {
            return string.substring(2);
        }
        return string;
    }

    private void write(UnparsedTextList unparsedTextList) {
        if (unparsedTextList.size() > 0) {
            for (int i = 0; i < unparsedTextList.size(); ++i) {
                if (!unparsedTextList.isMessage(new Integer(i)).booleanValue()) continue;
                this.write(unparsedTextList.getText(new Integer(i)));
            }
        }
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Caught exception in FINWriterVisitor, method write", iOException);
            throw new WifeException(iOException);
        }
    }
}

