/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.WifeException;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwiftParser {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private static final transient Logger log = Logger.getLogger(SwiftParser.class.getName());
    private Reader reader;
    private StringBuffer buffer;
    private SwiftMessage currentMessage;
    private final List errors = new ArrayList();
    private int lastBlockStartOffset = 0;

    public SwiftParser(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public SwiftParser(Reader reader) {
        this.setReader(reader);
    }

    public SwiftParser(String string) {
        this(new StringReader(string));
    }

    public SwiftParser() {
    }

    public void setReader(Reader reader) {
        this.buffer = new StringBuffer();
        this.reader = reader;
    }

    public void setData(String string) {
        this.setReader(new StringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwiftMessage message() throws IOException {
        SwiftMessage swiftMessage;
        this.currentMessage = swiftMessage = new SwiftMessage(false);
        this.errors.clear();
        try {
            boolean bl = false;
            SwiftBlock swiftBlock = null;
            do {
                if ((swiftBlock = this.consumeBlock()) != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("consumed block: " + swiftBlock);
                    }
                    this.currentMessage.addBlock(swiftBlock);
                    continue;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.finer("no block consumed");
                }
                bl = true;
            } while (!bl);
        }
        finally {
            this.currentMessage = null;
        }
        return swiftMessage;
    }

    public SwiftMessage parse(String string) throws IOException {
        this.setData(string);
        return this.message();
    }

    protected SwiftBlock consumeBlock() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("consumeBlock: findBlockStart()");
        }
        this.findBlockStart();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("block start found");
        }
        String string = this.readUntilBlockEnds();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("block buffer: [" + string + "]");
        }
        if (string.equals("")) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("end of input");
            }
            return null;
        }
        if (string.startsWith("1:")) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Possible unparsed text");
            }
            if (this.currentMessage != null && this.currentMessage.getBlock1() != null) {
                UnparsedTextList unparsedTextList;
                Object object;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("It is an unparsed text");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{");
                stringBuffer.append(string);
                stringBuffer.append("}");
                boolean bl = false;
                while (!bl) {
                    object = new char[128];
                    int n = this.reader.read((char[])object);
                    if (n > 0) {
                        stringBuffer.append((char[])object);
                        continue;
                    }
                    bl = true;
                }
                object = stringBuffer.toString();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("unparsed texts to process: [" + (String)object + "]");
                }
                if ((unparsedTextList = this.processUnparsedText((String)object)) != null) {
                    this.currentMessage.setUnparsedTexts(unparsedTextList);
                }
                return null;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Regular block");
            }
        }
        char c = this.identifyBlock(string);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("blockId: " + c);
        }
        SwiftBlock swiftBlock = null;
        if (c == ' ') {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("A block could not be identified!");
                log.severe("unidentified block:" + string);
            }
            throw new WifeException("The block " + string + " could not be identified");
        }
        switch (c) {
            case '1': {
                swiftBlock = new SwiftBlock1(string);
                break;
            }
            case '2': {
                if (this.isInput(string)) {
                    swiftBlock = new SwiftBlock2Input(string);
                    break;
                }
                swiftBlock = new SwiftBlock2Output(string);
                break;
            }
            case '3': {
                swiftBlock = this.tagListBlockConsume(new SwiftBlock3(), string);
                break;
            }
            case '4': {
                if (this.isTextBlock(string)) {
                    swiftBlock = this.block4Consume(new SwiftBlock4(), string);
                    break;
                }
                swiftBlock = this.tagListBlockConsume(new SwiftBlock4(), string);
                break;
            }
            case '5': {
                swiftBlock = this.tagListBlockConsume(new SwiftBlock5(), string);
                break;
            }
            default: {
                swiftBlock = this.tagListBlockConsume(new SwiftBlockUser(Character.toString(c)), string);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Block consumed: " + swiftBlock);
        }
        return swiftBlock;
    }

    private boolean isInput(String string) {
        int n;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("block 2 type detection: " + string);
        }
        if ((n = string.indexOf(58)) >= 0 && n + 1 < string.length()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("checking if [" + Character.toUpperCase(string.charAt(n + 1)) + "] is input");
            }
            return Character.toUpperCase(string.charAt(n + 1)) == 'I';
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("assuming output block 2");
        }
        return false;
    }

    protected SwiftTagListBlock tagListBlockConsume(SwiftTagListBlock swiftTagListBlock, String string) throws IOException {
        int n;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("data to consume: " + string);
        }
        if ((n = string.indexOf(58)) >= 0 && n + 1 < string.length()) {
            String string2 = string.substring(n + 1);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("data: " + string2);
            }
            for (int i = 0; i < string2.length(); ++i) {
                String string3;
                int n2;
                char c = string2.charAt(i);
                if (c == '{') {
                    n2 = string2.indexOf(125, i);
                    if (n2 < 0 || string2.length() <= n2) continue;
                    string3 = string2.substring(i + 1, n2);
                    i = n2;
                    Tag tag = new Tag(string3);
                    log.finest("" + tag);
                    swiftTagListBlock.addTag(tag);
                    continue;
                }
                for (n2 = i; n2 < string2.length() && string2.charAt(n2) != '{'; ++n2) {
                }
                string3 = string2.substring(i, n2).trim();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("possible block unparsed text: \"" + string3 + "\"");
                }
                if (!"".equals(string3)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("adding block unparsed text: \"" + string3 + "\"");
                    }
                    swiftTagListBlock.unparsedTextAddText(string3);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.finest("ingoring empty trimed unparsed text");
                }
                i = n2 - 1;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processed block: " + swiftTagListBlock);
        }
        return swiftTagListBlock;
    }

    protected SwiftBlock4 block4Consume(SwiftBlock4 swiftBlock4, String string) throws IOException {
        int n;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("block4Consume [" + string + "]");
        }
        if (string.charAt(n = 0) == '4') {
            ++n;
        }
        if (string.charAt(n) == ':') {
            ++n;
        }
        boolean bl = this.isTextBlock(string);
        Tag tag = null;
        while (n < string.length()) {
            int n2;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("parsing at: begin [" + n + "] buffer [" + string.substring(n) + "]");
            }
            int n3 = n;
            int n4 = 32;
            do {
                n2 = n4;
                n4 = string.charAt(n++);
            } while (n < string.length() && n4 != 58 && n4 != 123 && (n2 != 45 || n4 != 125));
            if (log.isLoggable(Level.FINEST)) {
                log.finest("position: begin [" + n3 + "] current [" + n + "]");
            }
            int n5 = 0;
            if (n4 == 125 && string.charAt(n - 1) == '-') {
                n5 = 1;
            }
            String string2 = string.substring(n3, n - n5 - 1).trim();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("possible block unparsed text: \"" + string2 + "\"");
            }
            if (!"".equals(string2)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("adding block unparsed text: \"" + string2 + "\"");
                }
                swiftBlock4.unparsedTextAddText(string2);
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("ingoring empty trimed unparsed text");
            }
            if (n == string.length()) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("reached end of input, terminating");
                continue;
            }
            int n6 = 0;
            String string3 = null;
            String string4 = null;
            switch (n4) {
                case 125: {
                    if (n != string.length() && log.isLoggable(Level.FINEST)) {
                        log.finest("reached end of block with pending input [" + string.substring(n) + "]");
                    }
                    if (bl && n5 == 1 || !bl) {
                        n = string.length();
                    }
                    log.severe("malformed message: exit by bracket");
                }
                case 58: {
                    n6 = this.textTagEndBlock4(string, n, bl);
                    string3 = string.substring(n, n6);
                    break;
                }
                case 123: {
                    if (string.startsWith("1:", n)) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("processing block unparsed text at [" + (n - 1) + "]");
                        }
                        n3 = n > 0 ? n - 1 : 0;
                        n6 = n3 + 1;
                        while (n6 < string.length() && !string.startsWith("{1:", n6)) {
                            n6 = this.blockTagEnd(string, n6 + 1);
                        }
                        string2 = string.substring(n3, n6);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("block unparsed text from [" + n3 + "] to [" + n6 + "] is [" + string2 + "]");
                        }
                        swiftBlock4.unparsedTextAddText(string2);
                        break;
                    }
                    n6 = this.blockTagEnd(string, n);
                    string3 = string.substring(n, n6 - 1);
                    int n7 = string3.indexOf("{1:");
                    if (n7 == -1) break;
                    string4 = string3.substring(n7);
                    string3 = string3.substring(0, n7);
                }
            }
            if (string3 != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("position: begin [" + n3 + "] current [" + n + "] end [" + n6 + "]");
                    log.finest("processing tag [" + string3 + "]");
                }
                Tag tag2 = this.consumeTag(string3, string4);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("consumed tag [" + tag2 + "]");
                }
                if (tag2 != null) {
                    swiftBlock4.addTag(tag2);
                    tag = tag2;
                }
            }
            n = n6;
        }
        this.stripEOB(tag);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processed block: " + swiftBlock4);
        }
        return swiftBlock4;
    }

    private void stripEOB(Tag tag) {
        String string;
        if (tag != null && (string = tag.getValue()) != null) {
            if (string.endsWith("\r\n-")) {
                tag.setValue(string.substring(0, string.length() - 3));
            } else if (string.endsWith("\n-")) {
                tag.setValue(string.substring(0, string.length() - 2));
            }
        }
    }

    protected int textTagEndBlock4(String string, int n, boolean bl) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("textTagEnd: scan for text tag end starting at [" + n + "]");
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("textTagEnd: cheking char [" + c + "]");
            }
            if (c == '\r' || c == '\n') {
                char c2;
                int n2 = n;
                if (n + 1 == string.length()) break;
                c = string.charAt(++n);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("textTagEnd: CR|LF cheking char [" + c + "]");
                }
                if (c == '\r' || c == '\n') {
                    if (n + 1 == string.length()) break;
                    c = string.charAt(++n);
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("textTagEnd: final CR|LF char to check [" + c + "]");
                }
                if (!(bl || c != '{' && c != '}')) {
                    n = n2;
                    break;
                }
                if (c == ':' && n != string.length() && (c2 = string.charAt(++n)) != '\r' && c2 != '\n') {
                    n = n2;
                    break;
                }
                n = n2;
            } else {
                if (c == '-') {
                    char c3 = c = n + 1 < string.length() ? (char)string.charAt(n + 1) : (char)' ';
                    if (c == '}' && bl) break;
                }
                if (c == '}' && !bl) break;
            }
            ++n;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("textTagEnd: found tag end at [" + n + "]");
        }
        return n;
    }

    private int blockTagEnd(String string, int n) {
        char c;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("blockTagEnd: scan for text tag end starting at [" + n + "]");
        }
        int n2 = 0;
        do {
            c = string.charAt(n++);
            switch (c) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    --n2;
                }
            }
        } while (n < string.length() && (n2 >= 0 || n2 == 0 && c != '}'));
        if (log.isLoggable(Level.FINEST)) {
            log.finest("blockTagEnd: found tag end at [" + n + "]");
        }
        return n;
    }

    protected Tag consumeTag(String string, String string2) throws IOException {
        char c;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("consumeTag: buffer [" + string + "]");
            log.finest("consumeTag: unparsedText [" + string2 + "]");
        }
        int n = string.indexOf(58);
        String string3 = null;
        String string4 = null;
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        } else {
            string4 = string;
        }
        if ((string3 == null || string3.equals("")) && (string4 == null || string4.equals(""))) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("consumeTag: ignoring empty tag");
            }
            return null;
        }
        int n2 = string4.length();
        if (n2 > 0 && ((c = string4.charAt(n2 - 1)) == '\r' || c == '\n')) {
            --n2;
        }
        if (n2 > 0 && ((c = string4.charAt(n2 - 1)) == '\r' || c == '\n')) {
            --n2;
        }
        if (n2 != string4.length()) {
            string4 = string4.substring(0, n2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "consumeTag: name [{0}] value [{1}]", new Object[]{string3, string4});
        }
        Tag tag = new Tag();
        if (string3 != null) {
            tag.setName(string3);
            tag.setValue(string4);
        } else {
            log.severe("Avoiding tag with null name and value " + string4);
        }
        if (string2 != null) {
            tag.setUnparsedTexts(this.processUnparsedText(string2));
        }
        return tag;
    }

    private UnparsedTextList processUnparsedText(String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processUnparsedText: len [" + string.length() + "] input [" + string + "]");
        }
        UnparsedTextList unparsedTextList = null;
        int n = 0;
        while (n < string.length()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("processUnparsedText: starting scan at [" + n + "] len [" + string.length() + "]");
            }
            int n2 = n + 1;
            while (n2 + 1 < string.length() && !string.startsWith("{1:", n2)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("processUnparsedText: entering end [" + n2 + "]");
                }
                for (n2 = this.blockTagEnd(string, n2 + 1); n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("processUnparsedText: skip white space char at [" + string.charAt(n2) + "] pos [" + n2 + "]");
                }
            }
            String string2 = string.substring(n, n2).trim();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("processUnparsedText: unparsed text is [" + string2 + "]");
            }
            if (!string2.equals("")) {
                if (unparsedTextList == null) {
                    unparsedTextList = new UnparsedTextList();
                }
                unparsedTextList.addText(string2);
            }
            n = n2;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processUnparsedText: returning [" + unparsedTextList + "]");
        }
        return unparsedTextList;
    }

    protected char identifyBlock(String string) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("identifyBlock('" + string + "')");
        }
        if (string != null && string.length() > 1) {
            char c = string.charAt(0);
            if ('0' <= c && c <= '9') {
                return c;
            }
            if ('a' <= c && c <= 'z') {
                return c;
            }
            if ('A' <= c && c <= 'Z') {
                return c;
            }
        }
        return ' ';
    }

    protected String readUntilBlockEnds() throws IOException {
        int n = this.buffer == null ? 0 : this.buffer.length();
        int n2 = 0;
        boolean bl = true;
        int n3 = 1;
        boolean bl2 = false;
        int n4 = 0;
        Boolean bl3 = null;
        while (!bl2) {
            int n5 = this.getChar();
            if (bl3 == null && n4++ >= 3 && (bl3 = Boolean.valueOf(this.isTextBlock())).booleanValue()) {
                bl = false;
            }
            if (n5 == -1) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found EOF");
                }
                bl2 = true;
                continue;
            }
            if (bl && this.isBlockStart((char)n5)) {
                ++n3;
            }
            if (this.isBlockEnd(bl3, n5)) {
                if (bl) {
                    if (--n3 == 0) {
                        bl2 = true;
                        continue;
                    }
                    ++n2;
                    continue;
                }
                bl2 = true;
                continue;
            }
            ++n2;
            if (!log.isLoggable(Level.FINEST)) continue;
            log.finest("len: " + n2);
            log.finest("block spans: " + this.buffer.substring(n));
        }
        int n6 = n + n2;
        if (bl && n3 != 0 && n6 - n > 0 && log.isLoggable(Level.FINEST)) {
            log.finest("unbalanced '{' and '}' inside block (starts=" + n3 + ")");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("start: " + n);
            log.finest("end: " + n6);
            log.finest("substring from start: " + this.buffer.substring(n));
            log.finest("len: " + n2);
        }
        return this.buffer.substring(n, n6);
    }

    private boolean isTextBlock() {
        if (this.lastBlockStartOffset >= 0 && this.buffer.length() > this.lastBlockStartOffset) {
            return this.isTextBlock(this.buffer.substring(this.lastBlockStartOffset));
        }
        return false;
    }

    private boolean isTextBlock(String string) {
        if (string.length() < 3) {
            return false;
        }
        int n = string.charAt(0) == '{' ? 1 : 0;
        char c = string.charAt(n + 0);
        char c2 = string.charAt(n + 1);
        if (c == '4' && c2 == ':') {
            int n2 = n + 2;
            while (n + n2 < string.length()) {
                char c3 = string.charAt(n + n2);
                ++n2;
                if (c3 == '{') {
                    return false;
                }
                if (c3 != ':') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isBlockEnd(Boolean bl, int n) {
        if (this.isBlockEnd((char)n)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("EOB char reached");
            }
            if (bl != null && bl.booleanValue()) {
                char c = this.buffer.charAt(this.buffer.length() - 2);
                char c2 = this.buffer.charAt(this.buffer.length() - 3);
                if (c2 == '\n' && c == '-') {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isBlockEnd(char c) {
        return c == '}';
    }

    protected void findBlockStart() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && !this.isBlockStart((char)n)) {
        }
    }

    private boolean isBlockStart(char c) {
        if (c == '{') {
            this.lastBlockStartOffset = this.buffer.length() - 1;
            return true;
        }
        return false;
    }

    private int getChar() throws IOException {
        int n = this.reader.read();
        if (n >= 0) {
            this.buffer.append((char)n);
        }
        return n;
    }

    public List getErrors() {
        return new ArrayList(this.errors);
    }
}

