/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class LocalDateAdapter
extends XmlAdapter<String, LocalDate> {
    private static String DATE_FORMAT = "yyyy-MM-dd";
    private DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATE_FORMAT);

    public LocalDateAdapter(DateTimeFormatter ofPattern) {
        this.dtf = ofPattern;
    }

    public LocalDateAdapter() {
    }

    public LocalDate unmarshal(String value) throws Exception {
        return LocalDate.parse(StringUtils.substring((String)value, (int)0, (int)10), this.dtf);
    }

    public String marshal(LocalDate value) throws Exception {
        if (value != null) {
            return this.dtf.format(value);
        }
        return null;
    }

    public String toString() {
        return "LocalDateAdapter{ " + DATE_FORMAT + " }";
    }
}

