
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Information on collateral used in the transaction.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransactionCollateralData14Choice", propOrder = {
    "rpTrad",
    "buySellBck",
    "sctiesLndg",
    "mrgnLndg"
})
public class TransactionCollateralData14Choice {

    @XmlElement(name = "RpTrad")
    protected Collateral35 rpTrad;
    @XmlElement(name = "BuySellBck")
    protected Collateral35 buySellBck;
    @XmlElement(name = "SctiesLndg")
    protected CollateralFlag10Choice sctiesLndg;
    @XmlElement(name = "MrgnLndg")
    protected List<Security16> mrgnLndg;

    /**
     * Gets the value of the rpTrad property.
     * 
     * @return
     *     possible object is
     *     {@link Collateral35 }
     *     
     */
    public Collateral35 getRpTrad() {
        return rpTrad;
    }

    /**
     * Sets the value of the rpTrad property.
     * 
     * @param value
     *     allowed object is
     *     {@link Collateral35 }
     *     
     */
    public TransactionCollateralData14Choice setRpTrad(Collateral35 value) {
        this.rpTrad = value;
        return this;
    }

    /**
     * Gets the value of the buySellBck property.
     * 
     * @return
     *     possible object is
     *     {@link Collateral35 }
     *     
     */
    public Collateral35 getBuySellBck() {
        return buySellBck;
    }

    /**
     * Sets the value of the buySellBck property.
     * 
     * @param value
     *     allowed object is
     *     {@link Collateral35 }
     *     
     */
    public TransactionCollateralData14Choice setBuySellBck(Collateral35 value) {
        this.buySellBck = value;
        return this;
    }

    /**
     * Gets the value of the sctiesLndg property.
     * 
     * @return
     *     possible object is
     *     {@link CollateralFlag10Choice }
     *     
     */
    public CollateralFlag10Choice getSctiesLndg() {
        return sctiesLndg;
    }

    /**
     * Sets the value of the sctiesLndg property.
     * 
     * @param value
     *     allowed object is
     *     {@link CollateralFlag10Choice }
     *     
     */
    public TransactionCollateralData14Choice setSctiesLndg(CollateralFlag10Choice value) {
        this.sctiesLndg = value;
        return this;
    }

    /**
     * Gets the value of the mrgnLndg property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mrgnLndg property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMrgnLndg().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Security16 }
     * 
     * 
     * @return
     *     The value of the mrgnLndg property.
     */
    public List<Security16> getMrgnLndg() {
        if (mrgnLndg == null) {
            mrgnLndg = new ArrayList<>();
        }
        return this.mrgnLndg;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the mrgnLndg list.
     * @see #getMrgnLndg()
     * 
     */
    public TransactionCollateralData14Choice addMrgnLndg(Security16 mrgnLndg) {
        getMrgnLndg().add(mrgnLndg);
        return this;
    }

}
