
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TradeType1Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TradeType1Code">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="OOBK"/>
 *     <enumeration value="OFBK"/>
 *     <enumeration value="BKTR"/>
 *     <enumeration value="COTR"/>
 *     <enumeration value="GUTR"/>
 *     <enumeration value="LKTR"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TradeType1Code")
@XmlEnum
public enum TradeType1Code {


    /**
     * On order book/market trade.
     * 
     */
    OOBK,

    /**
     * Trade that is over the counter.
     * 
     */
    OFBK,

    /**
     * Trade that is input manually in case of issue on the original trade that either was not processed or not received.
     * 
     */
    BKTR,

    /**
     * Trade that is generated following a corporate action.
     * 
     */
    COTR,

    /**
     * Trade generated by a give-up.
     * 
     */
    GUTR,

    /**
     * Trades coming from the application of a coorporate event.
     * 
     */
    LKTR;

    public String value() {
        return name();
    }

    public static TradeType1Code fromValue(String v) {
        return valueOf(v);
    }

}
