
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * The CCPDailyCashFlowsReport message is sent from the central counterparty to the national competent authority. It is used to inform the national competent authority of the operational performance and exposures that occurred in a central counterparty payment system.
 * 
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CCPDailyCashFlowsReportV02", propOrder = {
    "cncntrtnAgt",
    "sttlmAgt",
    "splmtryData"
})
public class CCPDailyCashFlowsReportV02 {

    @XmlElement(name = "CncntrtnAgt", required = true)
    protected List<ConcentrationAgent1> cncntrtnAgt;
    @XmlElement(name = "SttlmAgt", required = true)
    protected List<SettlementAgent2> sttlmAgt;
    @XmlElement(name = "SplmtryData")
    protected List<SupplementaryData1> splmtryData;

    /**
     * Gets the value of the cncntrtnAgt property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the cncntrtnAgt property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCncntrtnAgt().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConcentrationAgent1 }
     * 
     * 
     * @return
     *     The value of the cncntrtnAgt property.
     */
    public List<ConcentrationAgent1> getCncntrtnAgt() {
        if (cncntrtnAgt == null) {
            cncntrtnAgt = new ArrayList<>();
        }
        return this.cncntrtnAgt;
    }

    /**
     * Gets the value of the sttlmAgt property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sttlmAgt property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSttlmAgt().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SettlementAgent2 }
     * 
     * 
     * @return
     *     The value of the sttlmAgt property.
     */
    public List<SettlementAgent2> getSttlmAgt() {
        if (sttlmAgt == null) {
            sttlmAgt = new ArrayList<>();
        }
        return this.sttlmAgt;
    }

    /**
     * Gets the value of the splmtryData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the splmtryData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSplmtryData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplementaryData1 }
     * 
     * 
     * @return
     *     The value of the splmtryData property.
     */
    public List<SupplementaryData1> getSplmtryData() {
        if (splmtryData == null) {
            splmtryData = new ArrayList<>();
        }
        return this.splmtryData;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the cncntrtnAgt list.
     * @see #getCncntrtnAgt()
     * 
     */
    public CCPDailyCashFlowsReportV02 addCncntrtnAgt(ConcentrationAgent1 cncntrtnAgt) {
        getCncntrtnAgt().add(cncntrtnAgt);
        return this;
    }

    /**
     * Adds a new item to the sttlmAgt list.
     * @see #getSttlmAgt()
     * 
     */
    public CCPDailyCashFlowsReportV02 addSttlmAgt(SettlementAgent2 sttlmAgt) {
        getSttlmAgt().add(sttlmAgt);
        return this;
    }

    /**
     * Adds a new item to the splmtryData list.
     * @see #getSplmtryData()
     * 
     */
    public CCPDailyCashFlowsReportV02 addSplmtryData(SupplementaryData1 splmtryData) {
        getSplmtryData().add(splmtryData);
        return this;
    }

}
