
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AuthenticationMethod8Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="AuthenticationMethod8Code">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="TOKA"/>
 *     <enumeration value="ADDB"/>
 *     <enumeration value="BYPS"/>
 *     <enumeration value="BIOM"/>
 *     <enumeration value="CDHI"/>
 *     <enumeration value="CRYP"/>
 *     <enumeration value="CSCV"/>
 *     <enumeration value="MANU"/>
 *     <enumeration value="MERC"/>
 *     <enumeration value="MOBL"/>
 *     <enumeration value="FPIN"/>
 *     <enumeration value="NPIN"/>
 *     <enumeration value="OTHR"/>
 *     <enumeration value="PPSG"/>
 *     <enumeration value="PSVE"/>
 *     <enumeration value="PSWD"/>
 *     <enumeration value="TOKP"/>
 *     <enumeration value="SCRT"/>
 *     <enumeration value="SCNL"/>
 *     <enumeration value="CSEC"/>
 *     <enumeration value="SNCT"/>
 *     <enumeration value="ADDS"/>
 *     <enumeration value="CPSG"/>
 *     <enumeration value="TOKN"/>
 *     <enumeration value="UKNW"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AuthenticationMethod8Code")
@XmlEnum
public enum AuthenticationMethod8Code {


    /**
     * A token is used to verify an already performed authentication.
     * 
     */
    TOKA,

    /**
     * Cardholder billing address verification.
     * 
     */
    ADDB,

    /**
     * Authentication bypassed by the merchant.
     * 
     */
    BYPS,

    /**
     * Biometric authentication of the cardholder.
     * 
     */
    BIOM,

    /**
     * Cardholder data provided for verification, for instance social security number, driver license number, passport number.
     * 
     */
    CDHI,

    /**
     * Verification of a cryptogram generated by a chip card or another device, for instance ARQC (Authorisation Request Cryptogram).
     * 
     */
    CRYP,

    /**
     * Verification of Card Security Code.
     * 
     */
    CSCV,

    /**
     * Manual verification, for example passport or drivers license.
     * 
     */
    MANU,

    /**
     * Merchant-related authentication.
     * 
     */
    MERC,

    /**
     * Customer mobile device.
     * 
     */
    MOBL,

    /**
     * Off-line PIN authentication (Personal Identification Number).
     * 
     */
    FPIN,

    /**
     * On-line PIN authentication (Personal Identification Number).
     * 
     */
    NPIN,

    /**
     * Other customer authentication.
     * 
     */
    OTHR,

    /**
     * Handwritten paper signature.
     * 
     */
    PPSG,

    /**
     * Authentication based on statistical cardholder behaviour.
     * 
     */
    PSVE,

    /**
     * Authentication by a password.
     * 
     */
    PSWD,

    /**
     * Verification or authentication related to the use of a payment token, for instance the validation of the authorised use of a token.
     * 
     */
    TOKP,

    /**
     * Electronic commerce transaction secured with the X.509 certificate of a customer.
     * 
     */
    SCRT,

    /**
     * Channel-encrypted transaction.
     * 
     */
    SCNL,

    /**
     * Authentication performed during a secure electronic commerce transaction.
     * 
     */
    CSEC,

    /**
     * Secure electronic transaction without cardholder certificate.
     * 
     */
    SNCT,

    /**
     * Cardholder shipping address verification.
     * 
     */
    ADDS,

    /**
     * Electronic signature capture (handwritten signature).
     * 
     */
    CPSG,

    /**
     * Cryptogram generated by the token requestor or a customer device to validate the authorised use of a token.
     * 
     */
    TOKN,

    /**
     * Authentication method is performed unknown.
     * 
     */
    UKNW;

    public String value() {
        return name();
    }

    public static AuthenticationMethod8Code fromValue(String v) {
        return valueOf(v);
    }

}
