/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.JaxbContextCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class JaxbContextCacheImpl
implements JaxbContextCache {
    private Map<Class, JAXBContext> cachedMap;

    @Override
    public JAXBContext get(Class messageClass, Class<?>[] classes) throws JAXBException {
        JAXBContext context;
        if (this.cachedMap == null) {
            this.cachedMap = new ConcurrentHashMap<Class, JAXBContext>();
        }
        if ((context = this.cachedMap.get(messageClass)) == null) {
            context = classes != null && classes.length != 0 ? JAXBContext.newInstance((Class[])classes) : JAXBContext.newInstance((Class[])new Class[]{messageClass});
            this.cachedMap.put(messageClass, context);
        }
        return context;
    }

    public void clear() {
        this.cachedMap = null;
    }

    public JAXBContext clear(Class clazz) {
        if (this.cachedMap != null) {
            return this.cachedMap.remove(clazz);
        }
        return null;
    }

    public int size() {
        if (this.cachedMap != null) {
            return this.cachedMap.size();
        }
        return 0;
    }
}

