/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import com.prowidesoftware.swift.model.mx.MxWriteParams;
import com.prowidesoftware.swift.model.mx.MxWriteUtils;
import com.prowidesoftware.swift.model.mx.XMLGregorianCalendarUtils;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV03Impl;
import com.prowidesoftware.swift.model.mx.dic.Party44Choice;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AppHdr")
@XmlRootElement(name="AppHdr", namespace="urn:iso:std:iso:20022:tech:xsd:head.001.001.03")
public class BusinessAppHdrV03
extends BusinessApplicationHeaderV03Impl
implements AppHdr {
    public static final transient String NAMESPACE = "urn:iso:std:iso:20022:tech:xsd:head.001.001.03";
    static final transient Class[] _classes;
    private static final transient Logger log;

    public static BusinessAppHdrV03 parse(String xml) {
        return BusinessAppHdrV03.parse(xml, new MxReadParams());
    }

    public static BusinessAppHdrV03 parse(String xml, MxReadParams params) {
        Objects.requireNonNull(params, "The unmarshalling params cannot be null");
        return (BusinessAppHdrV03)MxParseUtils.parse(BusinessAppHdrV03.class, xml, _classes, "AppHdr", params);
    }

    Class[] getClasses() {
        return _classes;
    }

    @Override
    public String from() {
        return this.getBIC(this.getFr());
    }

    @Override
    public String to() {
        return this.getBIC(this.getTo());
    }

    private String getBIC(Party44Choice p) {
        try {
            String found = p.getFIId().getFinInstnId().getBICFI();
            if (!StringUtils.isEmpty((CharSequence)found)) {
                return found;
            }
        }
        catch (NullPointerException e) {
            try {
                String found = p.getOrgId().getId().getOrgId().getAnyBIC();
                if (!StringUtils.isEmpty((CharSequence)found)) {
                    return found;
                }
            }
            catch (NullPointerException e2) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String reference() {
        return this.getBizMsgIdr();
    }

    @Override
    public String messageName() {
        return this.getMsgDefIdr();
    }

    @Override
    public String serviceName() {
        return this.getBizSvc();
    }

    @Override
    public boolean duplicate() {
        return this.isPssblDplct() != null && this.isPssblDplct() != false || this.getCpyDplct() != null;
    }

    @Override
    public XMLGregorianCalendar creationDate() {
        return this.getCreDt();
    }

    @Override
    public void setCreationDate(boolean overwrite) {
        if (this.getCreDt() == null || overwrite) {
            this.setCreDt(XMLGregorianCalendarUtils.now());
        }
    }

    @Override
    @Deprecated
    public String xml(String prefix, boolean includeXMLDeclaration) {
        DeprecationUtils.phase2(AbstractMX.class, (String)"xml(String, boolean)", (String)"Use xml(MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        return this.xml(params);
    }

    @Override
    @Deprecated
    public String xml(String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        DeprecationUtils.phase2(AbstractMX.class, (String)"xml(String, boolean, EscapeHandler)", (String)"Use xml(MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        params.escapeHandler = escapeHandler;
        return this.xml(params);
    }

    @Override
    public String xml(MxWriteParams params) {
        try {
            JAXBContext context = params.context != null ? params.context : JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV03Impl.class});
            Marshaller marshaller = MxWriteUtils.createMarshaller(context, params);
            StringWriter sw = new StringWriter();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV03Impl.class, null, (Object)this);
            XmlEventWriter eventWriter = new XmlEventWriter(sw, params.prefix, params.includeXMLDeclaration, "AppHdr", params.escapeHandler, params.indent);
            marshaller.marshal((Object)element, (XMLEventWriter)eventWriter);
            return sw.getBuffer().toString();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.03 XML:" + e.getMessage());
            return null;
        }
    }

    @Override
    public Element element() {
        return this.element(null);
    }

    public Element element(JAXBContext inputContext) {
        try {
            JAXBContext context = inputContext != null ? inputContext : JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV03Impl.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult res = new DOMResult();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV03Impl.class, null, (Object)this);
            marshaller.marshal((Object)element, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.03 XML:" + e.getMessage());
            return null;
        }
    }

    @Override
    public String namespace() {
        return NAMESPACE;
    }

    static {
        log = Logger.getLogger(BusinessAppHdrV03.class.getName());
        _classes = Arrays.copyOf(BusinessApplicationHeaderV03Impl._classes, BusinessApplicationHeaderV03Impl._classes.length + 1);
        BusinessAppHdrV03._classes[BusinessAppHdrV03._classes.length - 1] = BusinessAppHdrV03.class;
    }
}

