
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for SettlementMethod2Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="SettlementMethod2Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="INDA"/&gt;
 *     &lt;enumeration value="INGA"/&gt;
 *     &lt;enumeration value="CLRG"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "SettlementMethod2Code")
@XmlEnum
public enum SettlementMethod2Code {


    /**
     * Settlement is done by the agent instructed to execute a payment instruction.
     * 
     */
    INDA,

    /**
     * Settlement is done by the agent instructing and forwarding the payment to the next party in the payment chain.
     * 
     */
    INGA,

    /**
     * Settlement is done through a payment clearing system.
     * 
     */
    CLRG;

    public String value() {
        return name();
    }

    public static SettlementMethod2Code fromValue(String v) {
        return valueOf(v);
    }

}
