
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AuthenticationMethod4Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="AuthenticationMethod4Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="NPIN"/&gt;
 *     &lt;enumeration value="PPSG"/&gt;
 *     &lt;enumeration value="PSWD"/&gt;
 *     &lt;enumeration value="SCRT"/&gt;
 *     &lt;enumeration value="SCNL"/&gt;
 *     &lt;enumeration value="SNCT"/&gt;
 *     &lt;enumeration value="CPSG"/&gt;
 *     &lt;enumeration value="ADDB"/&gt;
 *     &lt;enumeration value="BIOM"/&gt;
 *     &lt;enumeration value="CDHI"/&gt;
 *     &lt;enumeration value="CRYP"/&gt;
 *     &lt;enumeration value="CSCV"/&gt;
 *     &lt;enumeration value="PSVE"/&gt;
 *     &lt;enumeration value="CSEC"/&gt;
 *     &lt;enumeration value="ADDS"/&gt;
 *     &lt;enumeration value="TOKN"/&gt;
 *     &lt;enumeration value="MANU"/&gt;
 *     &lt;enumeration value="FPIN"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "AuthenticationMethod4Code")
@XmlEnum
public enum AuthenticationMethod4Code {


    /**
     * On-line PIN authentication (Personal Identification Number).
     * 
     */
    NPIN,

    /**
     * Handwritten paper signature.
     * 
     */
    PPSG,

    /**
     * Authentication by a password.
     * 
     */
    PSWD,

    /**
     * Electronic commerce transaction secured with the X.509 certificate of a customer.
     * 
     */
    SCRT,

    /**
     * Channel-encrypted transaction.
     * 
     */
    SCNL,

    /**
     * Secure electronic transaction without cardholder certificate.
     * 
     */
    SNCT,

    /**
     * Electronic signature capture (handwritten signature).
     * 
     */
    CPSG,

    /**
     * Cardholder billing address verification.
     * 
     */
    ADDB,

    /**
     * Biometric authentication of the cardholder.
     * 
     */
    BIOM,

    /**
     * Cardholder data provided for verification, for instance social security number, driver license number, passport number.
     * 
     */
    CDHI,

    /**
     * Verification of a cryptogram generated by a chip card or another device, for instance ARQC (Authorisation Request Cryptogram).
     * 
     */
    CRYP,

    /**
     * Verification of Card Security Code.
     * 
     */
    CSCV,

    /**
     * Authentication based on statistical cardholder behaviour.
     * 
     */
    PSVE,

    /**
     * Authentication performed during a secure electronic commerce transaction.
     * 
     */
    CSEC,

    /**
     * Cardholder shipping address verification.
     * 
     */
    ADDS,

    /**
     * Cryptogram generated by the token requestor or a customer device to validate the authorised use of a token.
     * 
     */
    TOKN,

    /**
     * Manual verification, for example passport or drivers license.
     * 
     */
    MANU,

    /**
     * Off-line PIN authentication (Personal Identification Number).
     * 
     */
    FPIN;

    public String value() {
        return name();
    }

    public static AuthenticationMethod4Code fromValue(String v) {
        return valueOf(v);
    }

}
