/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.prove.proveapi.utils.JSON;
import com.prove.proveapi.utils.QueryParameter;
import com.prove.proveapi.utils.QueryParamsMetadata;
import com.prove.proveapi.utils.Types;
import com.prove.proveapi.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryParameters {
    public static <T> List<QueryParameter> parseQueryParams(Class<T> type, T queryParams, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        Field[] fields;
        ArrayList<QueryParameter> allParams = new ArrayList<QueryParameter>();
        block10: for (Field field : fields = type.getDeclaredFields()) {
            QueryParamsMetadata queryParamsMetadata;
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object value = queryParams != null ? field.get(queryParams) : null;
            value = Utils.resolveStringShape(type, field.getName(), value);
            value = Utils.resolveOptionals(value);
            if ((value = Utils.populateGlobal(value, field.getName(), "queryParam", globals)) == null || (queryParamsMetadata = QueryParamsMetadata.parse(field)) == null) continue;
            if (queryParamsMetadata.serialization != null && !queryParamsMetadata.serialization.isBlank()) {
                List<QueryParameter> params = QueryParameters.parseSerializedParams(queryParamsMetadata, value);
                allParams.addAll(params);
                continue;
            }
            switch (queryParamsMetadata.style) {
                case "form": {
                    List<QueryParameter> formParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, ",");
                    allParams.addAll(formParams);
                    continue block10;
                }
                case "deepObject": {
                    List<QueryParameter> deepObjectParams = QueryParameters.parseDeepObjectParams(queryParamsMetadata, value);
                    allParams.addAll(deepObjectParams);
                    continue block10;
                }
                case "pipeDelimited": {
                    List<QueryParameter> pipeDelimitedParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, "|");
                    allParams.addAll(pipeDelimitedParams);
                    continue block10;
                }
            }
        }
        return allParams;
    }

    private static List<QueryParameter> parseSerializedParams(QueryParamsMetadata queryParamsMetadata, Object value) throws JsonProcessingException {
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        switch (queryParamsMetadata.serialization) {
            case "json": {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(value);
                params.add(QueryParameter.of(queryParamsMetadata.name, json, queryParamsMetadata.allowReserved));
                break;
            }
        }
        return params;
    }

    private static List<QueryParameter> parseDelimitedParams(QueryParamsMetadata queryParamsMetadata, Object value, String delimiter) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        switch (Types.getType(value.getClass())) {
            case ARRAY: {
                List<?> array = Utils.toList(value);
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<String> items = new ArrayList<String>();
                for (Object v2 : array) {
                    if (queryParamsMetadata.explode) {
                        values.add(Utils.valToString(v2));
                        continue;
                    }
                    items.add(Utils.valToString(v2));
                }
                if (items.size() > 0) {
                    values.add(String.join((CharSequence)delimiter, items));
                }
                params.addAll(values.stream().map(v -> QueryParameter.of(queryParamsMetadata.name, v, queryParamsMetadata.allowReserved)).collect(Collectors.toList()));
                break;
            }
            case MAP: {
                Map map = (Map)value;
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    String val = Utils.valToString(entry.getValue());
                    if (queryParamsMetadata.explode) {
                        params.add(QueryParameter.of(key, val, queryParamsMetadata.allowReserved));
                        continue;
                    }
                    items.add(String.format("%s%s%s", key, delimiter, val));
                }
                if (items.size() <= 0) break;
                params.add(QueryParameter.of(queryParamsMetadata.name, String.join((CharSequence)delimiter, items), queryParamsMetadata.allowReserved));
                break;
            }
            case OBJECT: {
                if (!Utils.allowIntrospection(value.getClass())) {
                    params.add(QueryParameter.of(queryParamsMetadata.name, Utils.valToString(value), queryParamsMetadata.allowReserved));
                    break;
                }
                Field[] fields = value.getClass().getDeclaredFields();
                ArrayList<String> items = new ArrayList<String>();
                for (Field field : fields) {
                    QueryParamsMetadata metadata;
                    field.setAccessible(true);
                    Object val = field.get(value);
                    val = Utils.resolveOptionals(val);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (queryParamsMetadata.explode) {
                        params.add(QueryParameter.of(metadata.name, Utils.valToString(val), metadata.allowReserved));
                        continue;
                    }
                    items.add(String.format("%s%s%s", metadata.name, delimiter, Utils.valToString(val)));
                }
                if (items.size() <= 0) break;
                params.add(QueryParameter.of(queryParamsMetadata.name, String.join((CharSequence)delimiter, items), queryParamsMetadata.allowReserved));
                break;
            }
            default: {
                params.add(QueryParameter.of(queryParamsMetadata.name, Utils.valToString(value), queryParamsMetadata.allowReserved));
            }
        }
        return params;
    }

    private static List<QueryParameter> parseDeepObjectParams(QueryParamsMetadata queryParamsMetadata, Object value) throws Exception {
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        switch (Types.getType(value.getClass())) {
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    Object val = Utils.resolveOptionals(entry.getValue());
                    if (val instanceof List || val.getClass().isArray()) {
                        for (Object v : Utils.toList(val)) {
                            params.add(QueryParameter.of(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(v), queryParamsMetadata.allowReserved));
                        }
                        continue;
                    }
                    params.add(QueryParameter.of(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(val), queryParamsMetadata.allowReserved));
                }
                return params;
            }
            case OBJECT: {
                Field[] fields;
                if (!Utils.allowIntrospection(value.getClass())) {
                    throw new RuntimeException("DeepObject style only supports Map and Object types, not " + value.getClass());
                }
                for (Field field : fields = value.getClass().getDeclaredFields()) {
                    QueryParamsMetadata metadata;
                    field.setAccessible(true);
                    Object val = field.get(value);
                    val = Utils.resolveOptionals(val);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (val instanceof List || val.getClass().isArray()) {
                        for (Object v : Utils.toList(val)) {
                            params.add(QueryParameter.of(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(v), metadata.allowReserved));
                        }
                        continue;
                    }
                    params.add(QueryParameter.of(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(val), metadata.allowReserved));
                }
                return params;
            }
        }
        throw new RuntimeException("DeepObject style only supports Map and Object types");
    }
}

