/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import java.util.Optional;

public class EventStreamMessage {
    private final Optional<String> event;
    private final Optional<String> id;
    private final Optional<Integer> retryMs;
    private final String data;

    public EventStreamMessage(Optional<String> event, Optional<String> id, Optional<Integer> retryMs, String data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.event = event;
        this.id = id;
        this.retryMs = retryMs;
        this.data = data;
    }

    public Optional<String> event() {
        return this.event;
    }

    public Optional<String> id() {
        return this.id;
    }

    public Optional<Integer> retryMs() {
        return this.retryMs;
    }

    public String data() {
        return this.data;
    }

    public boolean isEmpty() {
        return !this.event.isPresent() && !this.id().isPresent() && !this.retryMs().isPresent() && this.data.isEmpty();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.event.ifPresent(value -> b.append("event: " + value + "\n"));
        this.id.ifPresent(value -> b.append("id: " + value + "\n"));
        this.retryMs.ifPresent(value -> b.append("retry: " + value + "\n"));
        if (!this.data.isEmpty()) {
            b.append("data: " + this.data);
        }
        return b.toString();
    }
}

