/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3CompleteResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3CompleteRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3CompleteResponse> v3CompleteResponse;

    @JsonCreator
    public V3CompleteRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3CompleteResponse> v3CompleteResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3CompleteResponse, "v3CompleteResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3CompleteResponse = v3CompleteResponse;
    }

    public V3CompleteRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3CompleteResponse> v3CompleteResponse() {
        return this.v3CompleteResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3CompleteRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3CompleteRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3CompleteRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3CompleteRequestResponse withV3CompleteResponse(V3CompleteResponse v3CompleteResponse) {
        Utils.checkNotNull(v3CompleteResponse, "v3CompleteResponse");
        this.v3CompleteResponse = Optional.ofNullable(v3CompleteResponse);
        return this;
    }

    public V3CompleteRequestResponse withV3CompleteResponse(Optional<? extends V3CompleteResponse> v3CompleteResponse) {
        Utils.checkNotNull(v3CompleteResponse, "v3CompleteResponse");
        this.v3CompleteResponse = v3CompleteResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3CompleteRequestResponse other = (V3CompleteRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3CompleteResponse, other.v3CompleteResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3CompleteResponse);
    }

    public String toString() {
        return Utils.toString(V3CompleteRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3CompleteResponse", this.v3CompleteResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3CompleteResponse> v3CompleteResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3CompleteResponse(V3CompleteResponse v3CompleteResponse) {
            Utils.checkNotNull(v3CompleteResponse, "v3CompleteResponse");
            this.v3CompleteResponse = Optional.ofNullable(v3CompleteResponse);
            return this;
        }

        public Builder v3CompleteResponse(Optional<? extends V3CompleteResponse> v3CompleteResponse) {
            Utils.checkNotNull(v3CompleteResponse, "v3CompleteResponse");
            this.v3CompleteResponse = v3CompleteResponse;
            return this;
        }

        public V3CompleteRequestResponse build() {
            return new V3CompleteRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3CompleteResponse);
        }
    }
}

