/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3VerifyStatusRequest {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clientRequestId")
    private Optional<String> clientRequestId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="correlationId")
    private Optional<String> correlationId;

    @JsonCreator
    public V3VerifyStatusRequest(@JsonProperty(value="clientRequestId") Optional<String> clientRequestId, @JsonProperty(value="correlationId") Optional<String> correlationId) {
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        Utils.checkNotNull(correlationId, "correlationId");
        this.clientRequestId = clientRequestId;
        this.correlationId = correlationId;
    }

    public V3VerifyStatusRequest() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> clientRequestId() {
        return this.clientRequestId;
    }

    @JsonIgnore
    public Optional<String> correlationId() {
        return this.correlationId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3VerifyStatusRequest withClientRequestId(String clientRequestId) {
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        this.clientRequestId = Optional.ofNullable(clientRequestId);
        return this;
    }

    public V3VerifyStatusRequest withClientRequestId(Optional<String> clientRequestId) {
        Utils.checkNotNull(clientRequestId, "clientRequestId");
        this.clientRequestId = clientRequestId;
        return this;
    }

    public V3VerifyStatusRequest withCorrelationId(String correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = Optional.ofNullable(correlationId);
        return this;
    }

    public V3VerifyStatusRequest withCorrelationId(Optional<String> correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = correlationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3VerifyStatusRequest other = (V3VerifyStatusRequest)o;
        return Objects.deepEquals(this.clientRequestId, other.clientRequestId) && Objects.deepEquals(this.correlationId, other.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.clientRequestId, this.correlationId);
    }

    public String toString() {
        return Utils.toString(V3VerifyStatusRequest.class, "clientRequestId", this.clientRequestId, "correlationId", this.correlationId);
    }

    public static final class Builder {
        private Optional<String> clientRequestId = Optional.empty();
        private Optional<String> correlationId = Optional.empty();

        private Builder() {
        }

        public Builder clientRequestId(String clientRequestId) {
            Utils.checkNotNull(clientRequestId, "clientRequestId");
            this.clientRequestId = Optional.ofNullable(clientRequestId);
            return this;
        }

        public Builder clientRequestId(Optional<String> clientRequestId) {
            Utils.checkNotNull(clientRequestId, "clientRequestId");
            this.clientRequestId = clientRequestId;
            return this;
        }

        public Builder correlationId(String correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = Optional.ofNullable(correlationId);
            return this;
        }

        public Builder correlationId(Optional<String> correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = correlationId;
            return this;
        }

        public V3VerifyStatusRequest build() {
            return new V3VerifyStatusRequest(this.clientRequestId, this.correlationId);
        }
    }
}

