/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V3ValidateResponse {
    @JsonProperty(value="challengeMissing")
    private boolean challengeMissing;
    @JsonProperty(value="next")
    private Map<String, String> next;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="phoneNumber")
    private Optional<String> phoneNumber;
    @JsonProperty(value="success")
    private boolean success;

    @JsonCreator
    public V3ValidateResponse(@JsonProperty(value="challengeMissing") boolean challengeMissing, @JsonProperty(value="next") Map<String, String> next, @JsonProperty(value="phoneNumber") Optional<String> phoneNumber, @JsonProperty(value="success") boolean success) {
        Utils.checkNotNull(challengeMissing, "challengeMissing");
        next = Utils.emptyMapIfNull(next);
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(success, "success");
        this.challengeMissing = challengeMissing;
        this.next = next;
        this.phoneNumber = phoneNumber;
        this.success = success;
    }

    public V3ValidateResponse(boolean challengeMissing, Map<String, String> next, boolean success) {
        this(challengeMissing, next, Optional.empty(), success);
    }

    @JsonIgnore
    public boolean challengeMissing() {
        return this.challengeMissing;
    }

    @JsonIgnore
    public Map<String, String> next() {
        return this.next;
    }

    @JsonIgnore
    public Optional<String> phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public boolean success() {
        return this.success;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ValidateResponse withChallengeMissing(boolean challengeMissing) {
        Utils.checkNotNull(challengeMissing, "challengeMissing");
        this.challengeMissing = challengeMissing;
        return this;
    }

    public V3ValidateResponse withNext(Map<String, String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    public V3ValidateResponse withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = Optional.ofNullable(phoneNumber);
        return this;
    }

    public V3ValidateResponse withPhoneNumber(Optional<String> phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public V3ValidateResponse withSuccess(boolean success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ValidateResponse other = (V3ValidateResponse)o;
        return Objects.deepEquals(this.challengeMissing, other.challengeMissing) && Objects.deepEquals(this.next, other.next) && Objects.deepEquals(this.phoneNumber, other.phoneNumber) && Objects.deepEquals(this.success, other.success);
    }

    public int hashCode() {
        return Objects.hash(this.challengeMissing, this.next, this.phoneNumber, this.success);
    }

    public String toString() {
        return Utils.toString(V3ValidateResponse.class, "challengeMissing", this.challengeMissing, "next", this.next, "phoneNumber", this.phoneNumber, "success", this.success);
    }

    public static final class Builder {
        private Boolean challengeMissing;
        private Map<String, String> next;
        private Optional<String> phoneNumber = Optional.empty();
        private Boolean success;

        private Builder() {
        }

        public Builder challengeMissing(boolean challengeMissing) {
            Utils.checkNotNull(challengeMissing, "challengeMissing");
            this.challengeMissing = challengeMissing;
            return this;
        }

        public Builder next(Map<String, String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Optional<String> phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder success(boolean success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }

        public V3ValidateResponse build() {
            return new V3ValidateResponse(this.challengeMissing, this.next, this.phoneNumber, this.success);
        }
    }
}

