/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.IDVDataInternal;
import com.prove.proveapi.models.components.KYCInternal;
import com.prove.proveapi.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V3CompleteResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="idv")
    private Optional<? extends IDVDataInternal> idv;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="kyc")
    private Optional<? extends KYCInternal> kyc;
    @JsonProperty(value="next")
    private Map<String, String> next;
    @JsonProperty(value="success")
    private boolean success;

    @JsonCreator
    public V3CompleteResponse(@JsonProperty(value="idv") Optional<? extends IDVDataInternal> idv, @JsonProperty(value="kyc") Optional<? extends KYCInternal> kyc, @JsonProperty(value="next") Map<String, String> next, @JsonProperty(value="success") boolean success) {
        Utils.checkNotNull(idv, "idv");
        Utils.checkNotNull(kyc, "kyc");
        next = Utils.emptyMapIfNull(next);
        Utils.checkNotNull(success, "success");
        this.idv = idv;
        this.kyc = kyc;
        this.next = next;
        this.success = success;
    }

    public V3CompleteResponse(Map<String, String> next, boolean success) {
        this(Optional.empty(), Optional.empty(), next, success);
    }

    @JsonIgnore
    public Optional<IDVDataInternal> idv() {
        return this.idv;
    }

    @JsonIgnore
    public Optional<KYCInternal> kyc() {
        return this.kyc;
    }

    @JsonIgnore
    public Map<String, String> next() {
        return this.next;
    }

    @JsonIgnore
    public boolean success() {
        return this.success;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3CompleteResponse withIdv(IDVDataInternal idv) {
        Utils.checkNotNull(idv, "idv");
        this.idv = Optional.ofNullable(idv);
        return this;
    }

    public V3CompleteResponse withIdv(Optional<? extends IDVDataInternal> idv) {
        Utils.checkNotNull(idv, "idv");
        this.idv = idv;
        return this;
    }

    public V3CompleteResponse withKyc(KYCInternal kyc) {
        Utils.checkNotNull(kyc, "kyc");
        this.kyc = Optional.ofNullable(kyc);
        return this;
    }

    public V3CompleteResponse withKyc(Optional<? extends KYCInternal> kyc) {
        Utils.checkNotNull(kyc, "kyc");
        this.kyc = kyc;
        return this;
    }

    public V3CompleteResponse withNext(Map<String, String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    public V3CompleteResponse withSuccess(boolean success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3CompleteResponse other = (V3CompleteResponse)o;
        return Objects.deepEquals(this.idv, other.idv) && Objects.deepEquals(this.kyc, other.kyc) && Objects.deepEquals(this.next, other.next) && Objects.deepEquals(this.success, other.success);
    }

    public int hashCode() {
        return Objects.hash(this.idv, this.kyc, this.next, this.success);
    }

    public String toString() {
        return Utils.toString(V3CompleteResponse.class, "idv", this.idv, "kyc", this.kyc, "next", this.next, "success", this.success);
    }

    public static final class Builder {
        private Optional<? extends IDVDataInternal> idv = Optional.empty();
        private Optional<? extends KYCInternal> kyc = Optional.empty();
        private Map<String, String> next;
        private Boolean success;

        private Builder() {
        }

        public Builder idv(IDVDataInternal idv) {
            Utils.checkNotNull(idv, "idv");
            this.idv = Optional.ofNullable(idv);
            return this;
        }

        public Builder idv(Optional<? extends IDVDataInternal> idv) {
            Utils.checkNotNull(idv, "idv");
            this.idv = idv;
            return this;
        }

        public Builder kyc(KYCInternal kyc) {
            Utils.checkNotNull(kyc, "kyc");
            this.kyc = Optional.ofNullable(kyc);
            return this;
        }

        public Builder kyc(Optional<? extends KYCInternal> kyc) {
            Utils.checkNotNull(kyc, "kyc");
            this.kyc = kyc;
            return this;
        }

        public Builder next(Map<String, String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public Builder success(boolean success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }

        public V3CompleteResponse build() {
            return new V3CompleteResponse(this.idv, this.kyc, this.next, this.success);
        }
    }
}

