/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3CompleteAddressEntryRequest {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="address")
    private Optional<String> address;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="city")
    private Optional<String> city;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="extendedAddress")
    private Optional<String> extendedAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="postalCode")
    private Optional<String> postalCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="region")
    private Optional<String> region;

    @JsonCreator
    public V3CompleteAddressEntryRequest(@JsonProperty(value="address") Optional<String> address, @JsonProperty(value="city") Optional<String> city, @JsonProperty(value="extendedAddress") Optional<String> extendedAddress, @JsonProperty(value="postalCode") Optional<String> postalCode, @JsonProperty(value="region") Optional<String> region) {
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(extendedAddress, "extendedAddress");
        Utils.checkNotNull(postalCode, "postalCode");
        Utils.checkNotNull(region, "region");
        this.address = address;
        this.city = city;
        this.extendedAddress = extendedAddress;
        this.postalCode = postalCode;
        this.region = region;
    }

    public V3CompleteAddressEntryRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> address() {
        return this.address;
    }

    @JsonIgnore
    public Optional<String> city() {
        return this.city;
    }

    @JsonIgnore
    public Optional<String> extendedAddress() {
        return this.extendedAddress;
    }

    @JsonIgnore
    public Optional<String> postalCode() {
        return this.postalCode;
    }

    @JsonIgnore
    public Optional<String> region() {
        return this.region;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3CompleteAddressEntryRequest withAddress(String address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public V3CompleteAddressEntryRequest withAddress(Optional<String> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public V3CompleteAddressEntryRequest withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = Optional.ofNullable(city);
        return this;
    }

    public V3CompleteAddressEntryRequest withCity(Optional<String> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    public V3CompleteAddressEntryRequest withExtendedAddress(String extendedAddress) {
        Utils.checkNotNull(extendedAddress, "extendedAddress");
        this.extendedAddress = Optional.ofNullable(extendedAddress);
        return this;
    }

    public V3CompleteAddressEntryRequest withExtendedAddress(Optional<String> extendedAddress) {
        Utils.checkNotNull(extendedAddress, "extendedAddress");
        this.extendedAddress = extendedAddress;
        return this;
    }

    public V3CompleteAddressEntryRequest withPostalCode(String postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = Optional.ofNullable(postalCode);
        return this;
    }

    public V3CompleteAddressEntryRequest withPostalCode(Optional<String> postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = postalCode;
        return this;
    }

    public V3CompleteAddressEntryRequest withRegion(String region) {
        Utils.checkNotNull(region, "region");
        this.region = Optional.ofNullable(region);
        return this;
    }

    public V3CompleteAddressEntryRequest withRegion(Optional<String> region) {
        Utils.checkNotNull(region, "region");
        this.region = region;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3CompleteAddressEntryRequest other = (V3CompleteAddressEntryRequest)o;
        return Objects.deepEquals(this.address, other.address) && Objects.deepEquals(this.city, other.city) && Objects.deepEquals(this.extendedAddress, other.extendedAddress) && Objects.deepEquals(this.postalCode, other.postalCode) && Objects.deepEquals(this.region, other.region);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.city, this.extendedAddress, this.postalCode, this.region);
    }

    public String toString() {
        return Utils.toString(V3CompleteAddressEntryRequest.class, "address", this.address, "city", this.city, "extendedAddress", this.extendedAddress, "postalCode", this.postalCode, "region", this.region);
    }

    public static final class Builder {
        private Optional<String> address = Optional.empty();
        private Optional<String> city = Optional.empty();
        private Optional<String> extendedAddress = Optional.empty();
        private Optional<String> postalCode = Optional.empty();
        private Optional<String> region = Optional.empty();

        private Builder() {
        }

        public Builder address(String address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<String> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = Optional.ofNullable(city);
            return this;
        }

        public Builder city(Optional<String> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }

        public Builder extendedAddress(String extendedAddress) {
            Utils.checkNotNull(extendedAddress, "extendedAddress");
            this.extendedAddress = Optional.ofNullable(extendedAddress);
            return this;
        }

        public Builder extendedAddress(Optional<String> extendedAddress) {
            Utils.checkNotNull(extendedAddress, "extendedAddress");
            this.extendedAddress = extendedAddress;
            return this;
        }

        public Builder postalCode(String postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = Optional.ofNullable(postalCode);
            return this;
        }

        public Builder postalCode(Optional<String> postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = postalCode;
            return this;
        }

        public Builder region(String region) {
            Utils.checkNotNull(region, "region");
            this.region = Optional.ofNullable(region);
            return this;
        }

        public Builder region(Optional<String> region) {
            Utils.checkNotNull(region, "region");
            this.region = region;
            return this;
        }

        public V3CompleteAddressEntryRequest build() {
            return new V3CompleteAddressEntryRequest(this.address, this.city, this.extendedAddress, this.postalCode, this.region);
        }
    }
}

